/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.resolve;

import com.itextpdf.html2pdf.css.CssDeclaration;
import com.itextpdf.html2pdf.css.resolve.shorthand.impl.BorderShorthandResolver;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.html.node.IAttribute;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.html.node.INode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class HtmlStylesToCssConverter {
    private static final Map<String, IAttributeConverter> htmlAttributeConverters = new HashMap<String, IAttributeConverter>();

    HtmlStylesToCssConverter() {
    }

    public static List<CssDeclaration> convert(IElementNode element) {
        ArrayList<CssDeclaration> convertedHtmlStyles = new ArrayList<CssDeclaration>();
        if (element.getAdditionalHtmlStyles() != null) {
            HashMap<String, String> additionalStyles = new HashMap<String, String>();
            for (Map<String, String> map : element.getAdditionalHtmlStyles()) {
                additionalStyles.putAll(map);
            }
            convertedHtmlStyles.ensureCapacity(convertedHtmlStyles.size() + additionalStyles.size());
            for (Map.Entry entry : additionalStyles.entrySet()) {
                convertedHtmlStyles.add(new CssDeclaration((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        for (IAttribute a : element.getAttributes()) {
            IAttributeConverter iAttributeConverter = htmlAttributeConverters.get(a.getKey());
            if (iAttributeConverter == null || !iAttributeConverter.isSupportedForElement(element.name())) continue;
            convertedHtmlStyles.addAll(iAttributeConverter.convert(element, a.getValue()));
        }
        return convertedHtmlStyles;
    }

    static {
        htmlAttributeConverters.put("align", new AlignAttributeConverter());
        htmlAttributeConverters.put("border", new BorderAttributeConverter());
        htmlAttributeConverters.put("bgcolor", new BgColorAttributeConverter());
        htmlAttributeConverters.put("cellpadding", new CellPaddingAttributeConverter());
        htmlAttributeConverters.put("cellspacing", new CellSpacingAttributeConverter());
        htmlAttributeConverters.put("color", new FontColorAttributeConverter());
        htmlAttributeConverters.put("dir", new DirAttributeConverter());
        htmlAttributeConverters.put("size", new SizeAttributeConverter());
        htmlAttributeConverters.put("face", new FontFaceAttributeConverter());
        htmlAttributeConverters.put("noshade", new NoShadeAttributeConverter());
        htmlAttributeConverters.put("type", new TypeAttributeConverter());
        htmlAttributeConverters.put("width", new WidthAttributeConverter());
        htmlAttributeConverters.put("height", new HeightAttributeConverter());
        htmlAttributeConverters.put("valign", new VAlignAttributeConverter());
    }

    private static class VAlignAttributeConverter
    implements IAttributeConverter {
        private VAlignAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "td".equals(elementName) || "th".equals(elementName) || "tr".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            return Arrays.asList(new CssDeclaration("vertical-align", value));
        }
    }

    private static class NoShadeAttributeConverter
    implements IAttributeConverter {
        private NoShadeAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "hr".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            return Arrays.asList(new CssDeclaration("height", "2px"), new CssDeclaration("border-width", "0"), new CssDeclaration("background-color", "gray"));
        }
    }

    private static class AlignAttributeConverter
    implements IAttributeConverter {
        private AlignAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "hr".equals(elementName) || "table".equals(elementName) || "img".equals(elementName) || "td".equals(elementName) || "div".equals(elementName) || "p".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            ArrayList<CssDeclaration> result = new ArrayList<CssDeclaration>(2);
            if ("hr".equals(element.name()) || "table".equals(element.name()) && "center".equals(value)) {
                String leftMargin = null;
                String rightMargin = null;
                if ("right".equals(value)) {
                    leftMargin = "auto";
                    rightMargin = "0";
                } else if ("left".equals(value)) {
                    leftMargin = "0";
                    rightMargin = "auto";
                } else if ("center".equals(value)) {
                    leftMargin = "auto";
                    rightMargin = "auto";
                }
                if (leftMargin != null) {
                    result.add(new CssDeclaration("margin-left", leftMargin));
                    result.add(new CssDeclaration("margin-right", rightMargin));
                }
            } else if ("table".equals(element.name()) || "img".equals(element.name())) {
                if ("img".equals(element.name()) && "top".equals(value) && "middle".equals(value) && "bottom".equals(value)) {
                    result.add(new CssDeclaration("vertical-align", value));
                } else if ("left".equals(value) || "right".equals(value)) {
                    result.add(new CssDeclaration("float", value));
                }
            } else {
                result.add(new CssDeclaration("text-align", value));
            }
            return result;
        }
    }

    private static class HeightAttributeConverter
    implements IAttributeConverter {
        private HeightAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "img".equals(elementName) || "td".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            String cssEquivalent = value.replaceAll(";+$", "");
            if (!CssUtils.isMetricValue(cssEquivalent) && !cssEquivalent.endsWith("%")) {
                cssEquivalent = cssEquivalent + "px";
            }
            return Arrays.asList(new CssDeclaration("height", cssEquivalent));
        }
    }

    private static class WidthAttributeConverter
    implements IAttributeConverter {
        private WidthAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "hr".equals(elementName) || "img".equals(elementName) || "table".equals(elementName) || "td".equals(elementName) || "th".equals(elementName) || "colgroup".equals(elementName) || "col".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            String cssEquivalent = value.replaceAll(";+$", "");
            if (!CssUtils.isMetricValue(cssEquivalent) && !cssEquivalent.endsWith("%")) {
                cssEquivalent = cssEquivalent + "px";
            }
            return Arrays.asList(new CssDeclaration("width", cssEquivalent));
        }
    }

    private static class DirAttributeConverter
    implements IAttributeConverter {
        private DirAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return true;
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            return Arrays.asList(new CssDeclaration("direction", value));
        }
    }

    private static class TypeAttributeConverter
    implements IAttributeConverter {
        private TypeAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "ol".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            String cssEquivalent = null;
            switch (value) {
                case "1": {
                    cssEquivalent = "decimal";
                    break;
                }
                case "A": {
                    cssEquivalent = "upper-alpha";
                    break;
                }
                case "a": {
                    cssEquivalent = "lower-alpha";
                    break;
                }
                case "I": {
                    cssEquivalent = "upper-roman";
                    break;
                }
                case "i": {
                    cssEquivalent = "lower-roman";
                }
            }
            return Arrays.asList(new CssDeclaration("list-style-type", cssEquivalent));
        }
    }

    private static class FontFaceAttributeConverter
    implements IAttributeConverter {
        private FontFaceAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "font".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            return Arrays.asList(new CssDeclaration("font-family", value));
        }
    }

    private static class SizeAttributeConverter
    implements IAttributeConverter {
        private SizeAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "font".equals(elementName) || "hr".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            String cssValueEquivalent = null;
            String cssPropertyEquivalent = null;
            String elementName = element.name();
            if ("font".equals(elementName)) {
                cssPropertyEquivalent = "font-size";
                try {
                    boolean signedValue = value.contains("-") || value.contains("+");
                    int htmlFontSize = Integer.parseInt(value);
                    if (signedValue) {
                        htmlFontSize = 3 + htmlFontSize;
                    }
                    if (htmlFontSize < 2) {
                        cssValueEquivalent = "x-small";
                    } else if (htmlFontSize > 6) {
                        cssValueEquivalent = "48px";
                    } else if (htmlFontSize == 2) {
                        cssValueEquivalent = "small";
                    } else if (htmlFontSize == 3) {
                        cssValueEquivalent = "medium";
                    } else if (htmlFontSize == 4) {
                        cssValueEquivalent = "large";
                    } else if (htmlFontSize == 5) {
                        cssValueEquivalent = "x-large";
                    } else if (htmlFontSize == 6) {
                        cssValueEquivalent = "xx-large";
                    }
                }
                catch (NumberFormatException ex) {
                    cssValueEquivalent = "medium";
                }
            } else if ("hr".equals(elementName)) {
                cssPropertyEquivalent = "height";
                cssValueEquivalent = value + "px";
            }
            return Arrays.asList(new CssDeclaration(cssPropertyEquivalent, cssValueEquivalent));
        }
    }

    private static class FontColorAttributeConverter
    implements IAttributeConverter {
        private FontColorAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "font".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            return Arrays.asList(new CssDeclaration("color", value));
        }
    }

    private static class BgColorAttributeConverter
    implements IAttributeConverter {
        private static Set<String> supportedTags = new HashSet<String>(Arrays.asList("body", "col", "colgroup", "marquee", "table", "tbody", "tfoot", "td", "th", "tr"));

        private BgColorAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return supportedTags.contains(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            return Arrays.asList(new CssDeclaration("background-color", value));
        }
    }

    private static class CellSpacingAttributeConverter
    implements IAttributeConverter {
        private CellSpacingAttributeConverter() {
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "table".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            return Arrays.asList(new CssDeclaration("border-spacing", value));
        }
    }

    private static class CellPaddingAttributeConverter
    implements IAttributeConverter {
        private CellPaddingAttributeConverter() {
        }

        private static void applyPaddingsToTableCells(INode node, Map<String, String> paddingStyle) {
            List<INode> nodes = node.childNodes();
            for (INode childNode : nodes) {
                if (!(childNode instanceof IElementNode)) continue;
                IElementNode elementNode = (IElementNode)childNode;
                if ("td".equals(elementNode.name()) || "th".equals(elementNode.name())) {
                    elementNode.addAdditionalHtmlStyles(paddingStyle);
                    continue;
                }
                CellPaddingAttributeConverter.applyPaddingsToTableCells(childNode, paddingStyle);
            }
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "table".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            Float cellPadding = CssUtils.parseFloat(value);
            if (cellPadding != null && "table".equals(element.name())) {
                HashMap<String, String> styles = new HashMap<String, String>();
                styles.put("padding", value + "px");
                CellPaddingAttributeConverter.applyPaddingsToTableCells(element, styles);
            }
            return Collections.emptyList();
        }
    }

    private static class BorderAttributeConverter
    implements IAttributeConverter {
        private BorderAttributeConverter() {
        }

        private static void applyBordersToTableCells(INode node, Map<String, String> borderStyles) {
            List<INode> nodes = node.childNodes();
            for (INode childNode : nodes) {
                if (!(childNode instanceof IElementNode)) continue;
                IElementNode elementNode = (IElementNode)childNode;
                if ("td".equals(elementNode.name()) || "th".equals(elementNode.name())) {
                    elementNode.addAdditionalHtmlStyles(borderStyles);
                    continue;
                }
                BorderAttributeConverter.applyBordersToTableCells(childNode, borderStyles);
            }
        }

        @Override
        public boolean isSupportedForElement(String elementName) {
            return "img".equals(elementName) || "table".equals(elementName);
        }

        @Override
        public List<CssDeclaration> convert(IElementNode element, String value) {
            Float width = CssUtils.parseFloat(value);
            if (width != null) {
                if ("table".equals(element.name()) && width.floatValue() != 0.0f) {
                    List<CssDeclaration> declarations = new BorderShorthandResolver().resolveShorthand("1px solid");
                    HashMap<String, String> styles = new HashMap<String, String>(declarations.size());
                    for (CssDeclaration declaration : declarations) {
                        styles.put(declaration.getProperty(), declaration.getExpression());
                    }
                    BorderAttributeConverter.applyBordersToTableCells(element, styles);
                }
                if (width.floatValue() >= 0.0f) {
                    return Arrays.asList(new CssDeclaration("border", value + "px solid"));
                }
            }
            return Collections.emptyList();
        }
    }

    private static interface IAttributeConverter {
        public boolean isSupportedForElement(String var1);

        public List<CssDeclaration> convert(IElementNode var1, String var2);
    }
}

