/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.selector.item;

import com.itextpdf.html2pdf.css.selector.item.ICssSelectorItem;
import com.itextpdf.html2pdf.html.node.ICustomElementNode;
import com.itextpdf.html2pdf.html.node.IDocumentNode;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.html.node.INode;
import com.itextpdf.io.util.MessageFormatUtil;
import java.util.regex.Pattern;

public class CssAttributeSelectorItem
implements ICssSelectorItem {
    private String property;
    private char matchSymbol = '\u0000';
    private String value = null;

    public CssAttributeSelectorItem(String attrSelector) {
        int indexOfEqual = attrSelector.indexOf(61);
        if (indexOfEqual == -1) {
            this.property = attrSelector.substring(1, attrSelector.length() - 1);
        } else {
            this.value = attrSelector.charAt(indexOfEqual + 1) == '\"' || attrSelector.charAt(indexOfEqual + 1) == '\'' ? attrSelector.substring(indexOfEqual + 2, attrSelector.length() - 2) : attrSelector.substring(indexOfEqual + 1, attrSelector.length() - 1);
            this.matchSymbol = attrSelector.charAt(indexOfEqual - 1);
            if ("~^$*|".indexOf(this.matchSymbol) == -1) {
                this.matchSymbol = '\u0000';
                this.property = attrSelector.substring(1, indexOfEqual);
            } else {
                this.property = attrSelector.substring(1, indexOfEqual - 1);
            }
        }
    }

    @Override
    public int getSpecificity() {
        return 1024;
    }

    @Override
    public boolean matches(INode node) {
        if (!(node instanceof IElementNode) || node instanceof ICustomElementNode || node instanceof IDocumentNode) {
            return false;
        }
        IElementNode element = (IElementNode)node;
        String attributeValue = element.getAttribute(this.property);
        if (attributeValue == null) {
            return false;
        }
        if (this.value == null) {
            return true;
        }
        switch (this.matchSymbol) {
            case '\u0000': {
                return this.value.equals(attributeValue);
            }
            case '|': {
                return this.value.length() > 0 && attributeValue.startsWith(this.value) && (attributeValue.length() == this.value.length() || attributeValue.charAt(this.value.length()) == '-');
            }
            case '^': {
                return this.value.length() > 0 && attributeValue.startsWith(this.value);
            }
            case '$': {
                return this.value.length() > 0 && attributeValue.endsWith(this.value);
            }
            case '~': {
                String pattern = MessageFormatUtil.format((String)"(^{0}\\s+)|(\\s+{1}\\s+)|(\\s+{2}$)", (Object[])new Object[]{this.value, this.value, this.value});
                return Pattern.compile(pattern).matcher(attributeValue).matches();
            }
            case '*': {
                return this.value.length() > 0 && attributeValue.contains(this.value);
            }
        }
        return false;
    }

    public String toString() {
        if (this.value == null) {
            return MessageFormatUtil.format((String)"[{0}]", (Object[])new Object[]{this.property});
        }
        return MessageFormatUtil.format((String)"[{0}{1}=\"{2}\"]", (Object[])new Object[]{this.property, this.matchSymbol == '\u0000' ? "" : String.valueOf(this.matchSymbol), this.value});
    }
}

