/*
 * Decompiled with CFR 0.152.
 */
package butterknife.compiler;

import butterknife.compiler.FieldBitmapBinding;
import butterknife.compiler.FieldCollectionViewBinding;
import butterknife.compiler.FieldDrawableBinding;
import butterknife.compiler.FieldResourceBinding;
import butterknife.compiler.FieldViewBinding;
import butterknife.compiler.Id;
import butterknife.compiler.MethodViewBinding;
import butterknife.compiler.Parameter;
import butterknife.compiler.ViewBinding;
import butterknife.compiler.ViewBindings;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

final class BindingClass {
    private static final ClassName UTILS = ClassName.get((String)"butterknife.internal", (String)"Utils", (String[])new String[0]);
    private static final ClassName VIEW = ClassName.get((String)"android.view", (String)"View", (String[])new String[0]);
    private static final ClassName CONTEXT = ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]);
    private static final ClassName RESOURCES = ClassName.get((String)"android.content.res", (String)"Resources", (String[])new String[0]);
    private static final ClassName THEME = RESOURCES.nestedClass("Theme");
    private static final ClassName UNBINDER = ClassName.get((String)"butterknife", (String)"Unbinder", (String[])new String[0]);
    private static final ClassName BITMAP_FACTORY = ClassName.get((String)"android.graphics", (String)"BitmapFactory", (String[])new String[0]);
    private final Map<Id, ViewBindings> viewIdMap = new LinkedHashMap<Id, ViewBindings>();
    private final Map<FieldCollectionViewBinding, List<Id>> collectionBindings = new LinkedHashMap<FieldCollectionViewBinding, List<Id>>();
    private final List<FieldBitmapBinding> bitmapBindings = new ArrayList<FieldBitmapBinding>();
    private final List<FieldDrawableBinding> drawableBindings = new ArrayList<FieldDrawableBinding>();
    private final List<FieldResourceBinding> resourceBindings = new ArrayList<FieldResourceBinding>();
    private final boolean isFinal;
    private final TypeName targetTypeName;
    private final ClassName bindingClassName;
    private BindingClass parentBinding;

    BindingClass(TypeName targetTypeName, ClassName bindingClassName, boolean isFinal) {
        this.isFinal = isFinal;
        this.targetTypeName = targetTypeName;
        this.bindingClassName = bindingClassName;
    }

    void addBitmap(FieldBitmapBinding binding) {
        this.bitmapBindings.add(binding);
    }

    void addDrawable(FieldDrawableBinding binding) {
        this.drawableBindings.add(binding);
    }

    void addField(Id id, FieldViewBinding binding) {
        this.getOrCreateViewBindings(id).setFieldBinding(binding);
    }

    void addFieldCollection(List<Id> ids, FieldCollectionViewBinding binding) {
        this.collectionBindings.put(binding, ids);
    }

    boolean addMethod(Id id, ListenerClass listener, ListenerMethod method, MethodViewBinding binding) {
        ViewBindings viewBindings = this.getOrCreateViewBindings(id);
        if (viewBindings.hasMethodBinding(listener, method) && !"void".equals(method.returnType())) {
            return false;
        }
        viewBindings.addMethodBinding(listener, method, binding);
        return true;
    }

    void addResource(FieldResourceBinding binding) {
        this.resourceBindings.add(binding);
    }

    void setParent(BindingClass parent) {
        this.parentBinding = parent;
    }

    ViewBindings getViewBinding(Id id) {
        return this.viewIdMap.get(id);
    }

    private ViewBindings getOrCreateViewBindings(Id id) {
        ViewBindings viewId = this.viewIdMap.get(id);
        if (viewId == null) {
            viewId = new ViewBindings(id);
            this.viewIdMap.put(id, viewId);
        }
        return viewId;
    }

    JavaFile brewJava() {
        return JavaFile.builder((String)this.bindingClassName.packageName(), (TypeSpec)this.createBindingClass()).addFileComment("Generated code from Butter Knife. Do not modify!", new Object[0]).build();
    }

    private TypeSpec createBindingClass() {
        TypeVariableName targetType;
        TypeSpec.Builder result = TypeSpec.classBuilder((String)this.bindingClassName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.isFinal) {
            result.addModifiers(new Modifier[]{Modifier.FINAL});
            targetType = this.targetTypeName;
        } else {
            targetType = TypeVariableName.get((String)"T");
            result.addTypeVariable(TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{this.targetTypeName}));
        }
        if (this.hasParentBinding()) {
            result.superclass((TypeName)ParameterizedTypeName.get((ClassName)this.getParentBinding(), (TypeName[])new TypeName[]{targetType}));
        } else {
            result.addSuperinterface((TypeName)UNBINDER);
            result.addField((TypeName)targetType, "target", new Modifier[]{this.isFinal ? Modifier.PRIVATE : Modifier.PROTECTED});
        }
        if (!this.bindNeedsView()) {
            result.addMethod(this.createBindingViewDelegateConstructor((TypeName)targetType));
        }
        result.addMethod(this.createBindingConstructor((TypeName)targetType));
        if (this.hasViewBindings() || !this.hasParentBinding()) {
            result.addMethod(this.createBindingUnbindMethod(result, (TypeName)targetType));
        }
        return result.build();
    }

    private MethodSpec createBindingViewDelegateConstructor(TypeName targetType) {
        return MethodSpec.constructorBuilder().addJavadoc("@deprecated Use {@link #$T($T, $T)} for direct creation.\n    Only present for runtime invocation through {@code ButterKnife.bind()}.\n", new Object[]{this.bindingClassName, targetType, CONTEXT}).addAnnotation(Deprecated.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(targetType, "target", new Modifier[0]).addParameter((TypeName)VIEW, "source", new Modifier[0]).addStatement("this(target, source.getContext())", new Object[0]).build();
    }

    private MethodSpec createBindingConstructor(TypeName targetType) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.hasMethodBindings()) {
            constructor.addParameter(targetType, "target", new Modifier[]{Modifier.FINAL});
        } else {
            constructor.addParameter(targetType, "target", new Modifier[0]);
        }
        if (this.bindNeedsView()) {
            constructor.addParameter((TypeName)VIEW, "source", new Modifier[0]);
        } else {
            constructor.addParameter((TypeName)CONTEXT, "context", new Modifier[0]);
        }
        if (!this.hasParentBinding()) {
            constructor.addStatement("this.target = target", new Object[0]);
        } else if (this.parentBinding.bindNeedsView()) {
            constructor.addStatement("super(target, source)", new Object[0]);
        } else if (this.bindNeedsView()) {
            constructor.addStatement("super(target, source.getContext())", new Object[0]);
        } else {
            constructor.addStatement("super(target, context)", new Object[0]);
        }
        constructor.addCode("\n", new Object[0]);
        if (this.hasUnqualifiedResourceBindings()) {
            constructor.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"ResourceType"}).build());
        }
        if (this.hasViewBindings()) {
            if (this.bindNeedsViewLocal()) {
                constructor.addStatement("$T view", new Object[]{VIEW});
            }
            for (ViewBindings viewBindings : this.viewIdMap.values()) {
                this.addViewBindings(constructor, viewBindings);
            }
            for (Map.Entry entry : this.collectionBindings.entrySet()) {
                this.emitCollectionBinding(constructor, (FieldCollectionViewBinding)entry.getKey(), (List)entry.getValue());
            }
            if (this.hasResourceBindings()) {
                constructor.addCode("\n", new Object[0]);
            }
        }
        if (this.hasResourceBindings()) {
            boolean bl;
            boolean hasView = this.bindNeedsView();
            boolean bl2 = bl = this.bindNeedsTheme() && hasView;
            if (bl) {
                constructor.addStatement("$T context = source.getContext()", new Object[]{CONTEXT});
            }
            constructor.addStatement("$T res = $N.getResources()", new Object[]{RESOURCES, bl || !hasView ? "context" : "source"});
            if (this.bindNeedsTheme()) {
                constructor.addStatement("$T theme = context.getTheme()", new Object[]{THEME});
            }
            for (FieldBitmapBinding fieldBitmapBinding : this.bitmapBindings) {
                constructor.addStatement("target.$L = $T.decodeResource(res, $L)", new Object[]{fieldBitmapBinding.getName(), BITMAP_FACTORY, fieldBitmapBinding.getId().code});
            }
            for (FieldDrawableBinding fieldDrawableBinding : this.drawableBindings) {
                Id tintAttributeId = fieldDrawableBinding.getTintAttributeId();
                if (tintAttributeId.value != 0) {
                    constructor.addStatement("target.$L = $T.getTintedDrawable(res, theme, $L, $L)", new Object[]{fieldDrawableBinding.getName(), UTILS, fieldDrawableBinding.getId().code, tintAttributeId.code});
                    continue;
                }
                constructor.addStatement("target.$L = $T.getDrawable(res, theme, $L)", new Object[]{fieldDrawableBinding.getName(), UTILS, fieldDrawableBinding.getId().code});
            }
            for (FieldResourceBinding fieldResourceBinding : this.resourceBindings) {
                if (fieldResourceBinding.isThemeable()) {
                    constructor.addStatement("target.$L = $T.$L(res, theme, $L)", new Object[]{fieldResourceBinding.getName(), UTILS, fieldResourceBinding.getMethod(), fieldResourceBinding.getId().code});
                    continue;
                }
                constructor.addStatement("target.$L = res.$L($L)", new Object[]{fieldResourceBinding.getName(), fieldResourceBinding.getMethod(), fieldResourceBinding.getId().code});
            }
        }
        return constructor.build();
    }

    private MethodSpec createBindingUnbindMethod(TypeSpec.Builder bindingClass, TypeName targetType) {
        boolean rootBindingWithFields;
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"unbind").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        boolean bl = rootBindingWithFields = !this.hasParentBinding() && this.hasFieldBindings();
        if (this.hasFieldBindings() || rootBindingWithFields) {
            result.addStatement("$T target = this.target", new Object[]{targetType});
        }
        if (!this.hasParentBinding()) {
            String target = rootBindingWithFields ? "target" : "this.target";
            result.addStatement("if ($N == null) throw new $T($S)", new Object[]{target, IllegalStateException.class, "Bindings already cleared."});
        } else {
            result.addStatement("super.unbind()", new Object[0]);
        }
        if (this.hasFieldBindings()) {
            result.addCode("\n", new Object[0]);
            for (ViewBindings bindings : this.viewIdMap.values()) {
                if (bindings.getFieldBinding() == null) continue;
                result.addStatement("target.$L = null", new Object[]{bindings.getFieldBinding().getName()});
            }
            for (FieldCollectionViewBinding fieldCollectionBinding : this.collectionBindings.keySet()) {
                result.addStatement("target.$L = null", new Object[]{fieldCollectionBinding.getName()});
            }
        }
        if (this.hasMethodBindings()) {
            result.addCode("\n", new Object[0]);
            for (ViewBindings bindings : this.viewIdMap.values()) {
                this.addFieldAndUnbindStatement(bindingClass, result, bindings);
            }
        }
        if (!this.hasParentBinding()) {
            result.addCode("\n", new Object[0]);
            result.addStatement("this.target = null", new Object[0]);
        }
        return result.build();
    }

    private void addFieldAndUnbindStatement(TypeSpec.Builder result, MethodSpec.Builder unbindMethod, ViewBindings bindings) {
        Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> classMethodBindings = bindings.getMethodBindings();
        if (classMethodBindings.isEmpty()) {
            return;
        }
        String fieldName = bindings.isBoundToRoot() ? "viewSource" : "view" + bindings.getId().value;
        result.addField((TypeName)VIEW, fieldName, new Modifier[]{Modifier.PRIVATE});
        boolean needsNullChecked = bindings.getRequiredBindings().isEmpty();
        if (needsNullChecked) {
            unbindMethod.beginControlFlow("if ($N != null)", new Object[]{fieldName});
        }
        for (ListenerClass listenerClass : classMethodBindings.keySet()) {
            boolean requiresRemoval = !"".equals(listenerClass.remover());
            String listenerField = "null";
            if (requiresRemoval) {
                TypeName listenerClassName = BindingClass.bestGuess(listenerClass.type());
                listenerField = fieldName + ((ClassName)listenerClassName).simpleName();
                result.addField(listenerClassName, listenerField, new Modifier[]{Modifier.PRIVATE});
            }
            if (!"android.view.View".equals(listenerClass.targetType())) {
                unbindMethod.addStatement("(($T) $N).$N($N)", new Object[]{BindingClass.bestGuess(listenerClass.targetType()), fieldName, this.removerOrSetter(listenerClass, requiresRemoval), listenerField});
            } else {
                unbindMethod.addStatement("$N.$N($N)", new Object[]{fieldName, this.removerOrSetter(listenerClass, requiresRemoval), listenerField});
            }
            if (!requiresRemoval) continue;
            unbindMethod.addStatement("$N = null", new Object[]{listenerField});
        }
        unbindMethod.addStatement("$N = null", new Object[]{fieldName});
        if (needsNullChecked) {
            unbindMethod.endControlFlow();
        }
    }

    private String removerOrSetter(ListenerClass listenerClass, boolean requiresRemoval) {
        return requiresRemoval ? listenerClass.remover() : listenerClass.setter();
    }

    private void emitCollectionBinding(MethodSpec.Builder result, FieldCollectionViewBinding binding, List<Id> ids) {
        String ofName;
        switch (binding.getKind()) {
            case ARRAY: {
                ofName = "arrayOf";
                break;
            }
            case LIST: {
                ofName = "listOf";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown kind: " + (Object)((Object)binding.getKind()));
            }
        }
        CodeBlock.Builder builder = CodeBlock.builder();
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                builder.add(", ", new Object[0]);
            }
            builder.add("\n", new Object[0]);
            boolean requiresCast = BindingClass.requiresCast(binding.getType());
            if (!requiresCast && !binding.isRequired()) {
                builder.add("source.findViewById($L)", new Object[]{ids.get((int)i).code});
                continue;
            }
            builder.add("$T.find", new Object[]{UTILS});
            builder.add(binding.isRequired() ? "RequiredView" : "OptionalView", new Object[0]);
            if (requiresCast) {
                builder.add("AsType", new Object[0]);
            }
            builder.add("(source, $L", new Object[]{ids.get((int)i).code});
            if (binding.isRequired() || requiresCast) {
                builder.add(", $S", new Object[]{BindingClass.asHumanDescription(Collections.singletonList(binding))});
            }
            if (requiresCast) {
                builder.add(", $T.class", new Object[]{binding.getRawType()});
            }
            builder.add(")", new Object[0]);
        }
        result.addStatement("target.$L = $T.$L($L)", new Object[]{binding.getName(), UTILS, ofName, builder.build()});
    }

    private void addViewBindings(MethodSpec.Builder result, ViewBindings bindings) {
        if (bindings.isSingleFieldBinding()) {
            FieldViewBinding fieldBinding = bindings.getFieldBinding();
            CodeBlock.Builder builder = CodeBlock.builder().add("target.$L = ", new Object[]{fieldBinding.getName()});
            boolean requiresCast = BindingClass.requiresCast(fieldBinding.getType());
            if (!requiresCast && !fieldBinding.isRequired()) {
                builder.add("source.findViewById($L)", new Object[]{bindings.getId().code});
            } else {
                builder.add("$T.find", new Object[]{UTILS});
                builder.add(fieldBinding.isRequired() ? "RequiredView" : "OptionalView", new Object[0]);
                if (requiresCast) {
                    builder.add("AsType", new Object[0]);
                }
                builder.add("(source, $L", new Object[]{bindings.getId().code});
                if (fieldBinding.isRequired() || requiresCast) {
                    builder.add(", $S", new Object[]{BindingClass.asHumanDescription(Collections.singletonList(fieldBinding))});
                }
                if (requiresCast) {
                    builder.add(", $T.class", new Object[]{fieldBinding.getRawType()});
                }
                builder.add(")", new Object[0]);
            }
            result.addStatement("$L", new Object[]{builder.build()});
            return;
        }
        List<ViewBinding> requiredViewBindings = bindings.getRequiredBindings();
        if (requiredViewBindings.isEmpty()) {
            result.addStatement("view = source.findViewById($L)", new Object[]{bindings.getId().code});
        } else if (!bindings.isBoundToRoot()) {
            result.addStatement("view = $T.findRequiredView(source, $L, $S)", new Object[]{UTILS, bindings.getId().code, BindingClass.asHumanDescription(requiredViewBindings)});
        }
        this.addFieldBindings(result, bindings);
        this.addMethodBindings(result, bindings);
    }

    private void addFieldBindings(MethodSpec.Builder result, ViewBindings bindings) {
        FieldViewBinding fieldBinding = bindings.getFieldBinding();
        if (fieldBinding != null) {
            if (BindingClass.requiresCast(fieldBinding.getType())) {
                result.addStatement("target.$L = $T.castView(view, $L, $S, $T.class)", new Object[]{fieldBinding.getName(), UTILS, bindings.getId().code, BindingClass.asHumanDescription(Collections.singletonList(fieldBinding)), fieldBinding.getRawType()});
            } else {
                result.addStatement("target.$L = view", new Object[]{fieldBinding.getName()});
            }
        }
    }

    private void addMethodBindings(MethodSpec.Builder result, ViewBindings bindings) {
        Map<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> classMethodBindings = bindings.getMethodBindings();
        if (classMethodBindings.isEmpty()) {
            return;
        }
        boolean needsNullChecked = bindings.getRequiredBindings().isEmpty();
        if (needsNullChecked) {
            result.beginControlFlow("if (view != null)", new Object[0]);
        }
        String fieldName = "viewSource";
        String bindName = "source";
        if (!bindings.isBoundToRoot()) {
            fieldName = "view" + bindings.getId().value;
            bindName = "view";
        }
        result.addStatement("$L = $N", new Object[]{fieldName, bindName});
        for (Map.Entry<ListenerClass, Map<ListenerMethod, Set<MethodViewBinding>>> e : classMethodBindings.entrySet()) {
            ListenerClass listener = e.getKey();
            Map<ListenerMethod, Set<MethodViewBinding>> methodBindings = e.getValue();
            TypeSpec.Builder callback = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ClassName.bestGuess((String)listener.type()));
            for (ListenerMethod method : BindingClass.getListenerMethods(listener)) {
                MethodSpec.Builder callbackMethod = MethodSpec.methodBuilder((String)method.name()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(BindingClass.bestGuess(method.returnType()));
                String[] parameterTypes = method.parameters();
                int count = parameterTypes.length;
                for (int i = 0; i < count; ++i) {
                    callbackMethod.addParameter(BindingClass.bestGuess(parameterTypes[i]), "p" + i, new Modifier[0]);
                }
                boolean hasReturnType = !"void".equals(method.returnType());
                CodeBlock.Builder builder = CodeBlock.builder();
                if (hasReturnType) {
                    builder.add("return ", new Object[0]);
                }
                if (methodBindings.containsKey(method)) {
                    for (MethodViewBinding binding : methodBindings.get(method)) {
                        builder.add("target.$L(", new Object[]{binding.getName()});
                        List<Parameter> parameters = binding.getParameters();
                        String[] listenerParameters = method.parameters();
                        int count2 = parameters.size();
                        for (int i = 0; i < count2; ++i) {
                            int listenerPosition;
                            Parameter parameter;
                            if (i > 0) {
                                builder.add(", ", new Object[0]);
                            }
                            if ((parameter = parameters.get(i)).requiresCast(listenerParameters[listenerPosition = parameter.getListenerPosition()])) {
                                builder.add("$T.<$T>castParam(p$L, $S, $L, $S, $L)", new Object[]{UTILS, parameter.getType(), listenerPosition, method.name(), listenerPosition, binding.getName(), i});
                                continue;
                            }
                            builder.add("p$L", new Object[]{listenerPosition});
                        }
                        builder.add(");\n", new Object[0]);
                    }
                } else if (hasReturnType) {
                    builder.add("$L;\n", new Object[]{method.defaultReturn()});
                }
                callbackMethod.addCode(builder.build());
                callback.addMethod(callbackMethod.build());
            }
            boolean requiresRemoval = listener.remover().length() != 0;
            String listenerField = null;
            if (requiresRemoval) {
                TypeName listenerClassName = BindingClass.bestGuess(listener.type());
                listenerField = fieldName + ((ClassName)listenerClassName).simpleName();
                result.addStatement("$L = $L", new Object[]{listenerField, callback.build()});
            }
            if (!"android.view.View".equals(listener.targetType())) {
                result.addStatement("(($T) $N).$L($L)", new Object[]{BindingClass.bestGuess(listener.targetType()), bindName, listener.setter(), requiresRemoval ? listenerField : callback.build()});
                continue;
            }
            result.addStatement("$N.$L($L)", new Object[]{bindName, listener.setter(), requiresRemoval ? listenerField : callback.build()});
        }
        if (needsNullChecked) {
            result.endControlFlow();
        }
    }

    private static List<ListenerMethod> getListenerMethods(ListenerClass listener) {
        if (listener.method().length == 1) {
            return Arrays.asList(listener.method());
        }
        try {
            ArrayList<ListenerMethod> methods = new ArrayList<ListenerMethod>();
            Class callbacks = listener.callbacks();
            for (Enum callbackMethod : (Enum[])callbacks.getEnumConstants()) {
                Field callbackField = callbacks.getField(callbackMethod.name());
                ListenerMethod method = callbackField.getAnnotation(ListenerMethod.class);
                if (method == null) {
                    throw new IllegalStateException(String.format("@%s's %s.%s missing @%s annotation.", callbacks.getEnclosingClass().getSimpleName(), callbacks.getSimpleName(), callbackMethod.name(), ListenerMethod.class.getSimpleName()));
                }
                methods.add(method);
            }
            return methods;
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static String asHumanDescription(Collection<? extends ViewBinding> bindings) {
        Iterator<? extends ViewBinding> iterator = bindings.iterator();
        switch (bindings.size()) {
            case 1: {
                return iterator.next().getDescription();
            }
            case 2: {
                return iterator.next().getDescription() + " and " + iterator.next().getDescription();
            }
        }
        StringBuilder builder = new StringBuilder();
        int count = bindings.size();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            if (i == count - 1) {
                builder.append("and ");
            }
            builder.append(iterator.next().getDescription());
        }
        return builder.toString();
    }

    private static TypeName bestGuess(String type) {
        switch (type) {
            case "void": {
                return TypeName.VOID;
            }
            case "boolean": {
                return TypeName.BOOLEAN;
            }
            case "byte": {
                return TypeName.BYTE;
            }
            case "char": {
                return TypeName.CHAR;
            }
            case "double": {
                return TypeName.DOUBLE;
            }
            case "float": {
                return TypeName.FLOAT;
            }
            case "int": {
                return TypeName.INT;
            }
            case "long": {
                return TypeName.LONG;
            }
            case "short": {
                return TypeName.SHORT;
            }
        }
        int left = type.indexOf(60);
        if (left != -1) {
            ClassName typeClassName = ClassName.bestGuess((String)type.substring(0, left));
            ArrayList<WildcardTypeName> typeArguments = new ArrayList<WildcardTypeName>();
            do {
                typeArguments.add(WildcardTypeName.subtypeOf(Object.class));
            } while ((left = type.indexOf(60, left + 1)) != -1);
            return ParameterizedTypeName.get((ClassName)typeClassName, (TypeName[])typeArguments.toArray(new TypeName[typeArguments.size()]));
        }
        return ClassName.bestGuess((String)type);
    }

    private boolean hasParentBinding() {
        return this.parentBinding != null;
    }

    private ClassName getParentBinding() {
        return this.parentBinding.bindingClassName;
    }

    private boolean hasViewBindings() {
        return !this.viewIdMap.isEmpty() || !this.collectionBindings.isEmpty();
    }

    private boolean hasResourceBindings() {
        return !this.bitmapBindings.isEmpty() || !this.drawableBindings.isEmpty() || !this.resourceBindings.isEmpty();
    }

    private boolean hasUnqualifiedResourceBindings() {
        for (FieldBitmapBinding fieldBitmapBinding : this.bitmapBindings) {
            if (fieldBitmapBinding.getId().qualifed) continue;
            return true;
        }
        for (FieldDrawableBinding fieldDrawableBinding : this.drawableBindings) {
            if (fieldDrawableBinding.getId().qualifed) continue;
            return true;
        }
        for (FieldResourceBinding fieldResourceBinding : this.resourceBindings) {
            if (fieldResourceBinding.getId().qualifed) continue;
            return true;
        }
        return false;
    }

    private boolean hasResourceBindingsNeedingTheme() {
        if (!this.drawableBindings.isEmpty()) {
            return true;
        }
        for (FieldResourceBinding resourceBinding : this.resourceBindings) {
            if (!resourceBinding.isThemeable()) continue;
            return true;
        }
        return false;
    }

    private boolean hasMethodBindings() {
        for (ViewBindings viewBindings : this.viewIdMap.values()) {
            if (viewBindings.getMethodBindings().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean hasFieldBindings() {
        for (ViewBindings viewBindings : this.viewIdMap.values()) {
            if (viewBindings.getFieldBinding() == null) continue;
            return true;
        }
        return !this.collectionBindings.isEmpty();
    }

    private boolean bindNeedsView() {
        return this.hasViewBindings() || this.hasParentBinding() && this.parentBinding.bindNeedsView();
    }

    private boolean bindNeedsTheme() {
        return this.hasResourceBindings() && this.hasResourceBindingsNeedingTheme() || this.hasParentBinding() && this.parentBinding.bindNeedsTheme();
    }

    private boolean bindNeedsViewLocal() {
        for (ViewBindings viewBindings : this.viewIdMap.values()) {
            if (!viewBindings.requiresLocal()) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresCast(TypeName type) {
        return !"android.view.View".equals(type.toString());
    }

    public String toString() {
        return this.bindingClassName.toString();
    }
}

