/*
 * Decompiled with CFR 0.152.
 */
package butterknife.compiler;

import butterknife.BindArray;
import butterknife.BindBitmap;
import butterknife.BindBool;
import butterknife.BindColor;
import butterknife.BindDimen;
import butterknife.BindDrawable;
import butterknife.BindInt;
import butterknife.BindString;
import butterknife.BindView;
import butterknife.BindViews;
import butterknife.OnCheckedChanged;
import butterknife.OnClick;
import butterknife.OnEditorAction;
import butterknife.OnFocusChange;
import butterknife.OnItemClick;
import butterknife.OnItemLongClick;
import butterknife.OnItemSelected;
import butterknife.OnLongClick;
import butterknife.OnPageChange;
import butterknife.OnTextChanged;
import butterknife.OnTouch;
import butterknife.Optional;
import butterknife.compiler.BindingClass;
import butterknife.compiler.FieldBitmapBinding;
import butterknife.compiler.FieldCollectionViewBinding;
import butterknife.compiler.FieldDrawableBinding;
import butterknife.compiler.FieldResourceBinding;
import butterknife.compiler.FieldViewBinding;
import butterknife.compiler.Id;
import butterknife.compiler.MethodViewBinding;
import butterknife.compiler.Parameter;
import butterknife.compiler.ViewBindings;
import butterknife.internal.ListenerClass;
import butterknife.internal.ListenerMethod;
import com.google.auto.common.SuperficialValidation;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.sun.source.tree.ClassTree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public final class ButterKnifeProcessor
extends AbstractProcessor {
    static final Id NO_ID = new Id(-1);
    static final String VIEW_TYPE = "android.view.View";
    private static final String COLOR_STATE_LIST_TYPE = "android.content.res.ColorStateList";
    private static final String BITMAP_TYPE = "android.graphics.Bitmap";
    private static final String DRAWABLE_TYPE = "android.graphics.drawable.Drawable";
    private static final String TYPED_ARRAY_TYPE = "android.content.res.TypedArray";
    private static final String NULLABLE_ANNOTATION_NAME = "Nullable";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String LIST_TYPE = List.class.getCanonicalName();
    private static final String R = "R";
    private static final List<Class<? extends Annotation>> LISTENERS = Arrays.asList(OnCheckedChanged.class, OnClick.class, OnEditorAction.class, OnFocusChange.class, OnItemClick.class, OnItemLongClick.class, OnItemSelected.class, OnLongClick.class, OnPageChange.class, OnTextChanged.class, OnTouch.class);
    private static final List<String> SUPPORTED_TYPES = Arrays.asList("array", "attr", "bool", "color", "dimen", "drawable", "id", "integer", "string");
    private Elements elementUtils;
    private Types typeUtils;
    private Filer filer;
    private Trees trees;
    private final Map<Integer, Id> symbols = new LinkedHashMap<Integer, Id>();

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.elementUtils = env.getElementUtils();
        this.typeUtils = env.getTypeUtils();
        this.filer = env.getFiler();
        try {
            this.trees = Trees.instance(this.processingEnv);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (Class<? extends Annotation> annotation : this.getSupportedAnnotations()) {
            types.add(annotation.getCanonicalName());
        }
        return types;
    }

    private Set<Class<? extends Annotation>> getSupportedAnnotations() {
        LinkedHashSet<Class<? extends Annotation>> annotations = new LinkedHashSet<Class<? extends Annotation>>();
        annotations.add(BindArray.class);
        annotations.add(BindBitmap.class);
        annotations.add(BindBool.class);
        annotations.add(BindColor.class);
        annotations.add(BindDimen.class);
        annotations.add(BindDrawable.class);
        annotations.add(BindInt.class);
        annotations.add(BindString.class);
        annotations.add(BindView.class);
        annotations.add(BindViews.class);
        annotations.addAll(LISTENERS);
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        Map<TypeElement, BindingClass> targetClassMap = this.findAndParseTargets(env);
        for (Map.Entry<TypeElement, BindingClass> entry : targetClassMap.entrySet()) {
            TypeElement typeElement = entry.getKey();
            BindingClass bindingClass = entry.getValue();
            JavaFile javaFile = bindingClass.brewJava();
            try {
                javaFile.writeTo(this.filer);
            }
            catch (IOException e) {
                this.error(typeElement, "Unable to write binding for type %s: %s", typeElement, e.getMessage());
            }
        }
        return true;
    }

    private Map<TypeElement, BindingClass> findAndParseTargets(RoundEnvironment env) {
        LinkedHashMap<TypeElement, BindingClass> targetClassMap = new LinkedHashMap<TypeElement, BindingClass>();
        LinkedHashSet<TypeElement> erasedTargetNames = new LinkedHashSet<TypeElement>();
        this.scanForRClasses(env);
        for (Element element : env.getElementsAnnotatedWith(BindArray.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceArray(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindArray.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindBitmap.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceBitmap(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindBitmap.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindBool.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceBool(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindBool.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindColor.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceColor(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindColor.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindDimen.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceDimen(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindDimen.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindDrawable.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceDrawable(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindDrawable.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindInt.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceInt(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindInt.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindString.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseResourceString(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindString.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindView.class)) {
            try {
                this.parseBindView(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindView.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BindViews.class)) {
            try {
                this.parseBindViews(element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                this.logParsingError(element, BindViews.class, e);
            }
        }
        for (Class clazz : LISTENERS) {
            this.findAndParseListener(env, clazz, targetClassMap, erasedTargetNames);
        }
        for (Map.Entry entry : targetClassMap.entrySet()) {
            TypeElement parentType = this.findParentType((TypeElement)entry.getKey(), erasedTargetNames);
            if (parentType == null) continue;
            BindingClass bindingClass = (BindingClass)entry.getValue();
            BindingClass parentBindingClass = (BindingClass)targetClassMap.get(parentType);
            bindingClass.setParent(parentBindingClass);
        }
        return targetClassMap;
    }

    private void logParsingError(Element element, Class<? extends Annotation> annotation, Exception e) {
        StringWriter stackTrace = new StringWriter();
        e.printStackTrace(new PrintWriter(stackTrace));
        this.error(element, "Unable to parse @%s binding.\n\n%s", annotation.getSimpleName(), stackTrace);
    }

    private boolean isInaccessibleViaGeneratedCode(Class<? extends Annotation> annotationClass, String targetThing, Element element) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC)) {
            this.error(element, "@%s %s must not be private or static. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (enclosingElement.getKind() != ElementKind.CLASS) {
            this.error(enclosingElement, "@%s %s may only be contained in classes. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error(enclosingElement, "@%s %s may not be contained in private classes. (%s.%s)", annotationClass.getSimpleName(), targetThing, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        return hasError;
    }

    private boolean isBindingInWrongPackage(Class<? extends Annotation> annotationClass, Element element) {
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        String qualifiedName = enclosingElement.getQualifiedName().toString();
        if (qualifiedName.startsWith("android.")) {
            this.error(element, "@%s-annotated class incorrectly in Android framework package. (%s)", annotationClass.getSimpleName(), qualifiedName);
            return true;
        }
        if (qualifiedName.startsWith("java.")) {
            this.error(element, "@%s-annotated class incorrectly in Java framework package. (%s)", annotationClass.getSimpleName(), qualifiedName);
            return true;
        }
        return false;
    }

    private void parseBindView(Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        boolean hasError = this.isInaccessibleViaGeneratedCode(BindView.class, "fields", element) || this.isBindingInWrongPackage(BindView.class, element);
        TypeMirror elementType = element.asType();
        if (elementType.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVariable = (TypeVariable)elementType;
            elementType = typeVariable.getUpperBound();
        }
        if (!this.isSubtypeOfType(elementType, VIEW_TYPE) && !this.isInterface(elementType)) {
            if (elementType.getKind() == TypeKind.ERROR) {
                this.note(element, "@%s field with unresolved type (%s) must elsewhere be generated as a View or interface. (%s.%s)", BindView.class.getSimpleName(), elementType, enclosingElement.getQualifiedName(), element.getSimpleName());
            } else {
                this.error(element, "@%s fields must extend from View or be an interface. (%s.%s)", BindView.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
                hasError = true;
            }
        }
        if (hasError) {
            return;
        }
        int id = element.getAnnotation(BindView.class).value();
        BindingClass bindingClass = targetClassMap.get(enclosingElement);
        if (bindingClass != null) {
            ViewBindings viewBindings = bindingClass.getViewBinding(this.getId(id));
            if (viewBindings != null && viewBindings.getFieldBinding() != null) {
                FieldViewBinding existingBinding = viewBindings.getFieldBinding();
                this.error(element, "Attempt to use @%s for an already bound ID %d on '%s'. (%s.%s)", BindView.class.getSimpleName(), id, existingBinding.getName(), enclosingElement.getQualifiedName(), element.getSimpleName());
                return;
            }
        } else {
            bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        }
        String name = element.getSimpleName().toString();
        TypeName type = TypeName.get((TypeMirror)elementType);
        boolean required = ButterKnifeProcessor.isFieldRequired(element);
        FieldViewBinding binding = new FieldViewBinding(name, type, required);
        bindingClass.addField(this.getId(id), binding);
        erasedTargetNames.add(enclosingElement);
    }

    private void parseBindViews(Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        Integer duplicateId;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        boolean hasError = this.isInaccessibleViaGeneratedCode(BindViews.class, "fields", element) || this.isBindingInWrongPackage(BindViews.class, element);
        TypeMirror elementType = element.asType();
        String erasedType = this.doubleErasure(elementType);
        TypeMirror viewType = null;
        FieldCollectionViewBinding.Kind kind = null;
        if (elementType.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)elementType;
            viewType = arrayType.getComponentType();
            kind = FieldCollectionViewBinding.Kind.ARRAY;
        } else if (LIST_TYPE.equals(erasedType)) {
            DeclaredType declaredType = (DeclaredType)elementType;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.size() != 1) {
                this.error(element, "@%s List must have a generic component. (%s.%s)", BindViews.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
                hasError = true;
            } else {
                viewType = typeArguments.get(0);
            }
            kind = FieldCollectionViewBinding.Kind.LIST;
        } else {
            this.error(element, "@%s must be a List or array. (%s.%s)", BindViews.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (viewType != null && viewType.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVariable = (TypeVariable)viewType;
            viewType = typeVariable.getUpperBound();
        }
        if (viewType != null && !this.isSubtypeOfType(viewType, VIEW_TYPE) && !this.isInterface(viewType)) {
            if (viewType.getKind() == TypeKind.ERROR) {
                this.note(element, "@%s List or array with unresolved type (%s) must elsewhere be generated as a View or interface. (%s.%s)", BindViews.class.getSimpleName(), viewType, enclosingElement.getQualifiedName(), element.getSimpleName());
            } else {
                this.error(element, "@%s List or array type must extend from View or be an interface. (%s.%s)", BindViews.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
                hasError = true;
            }
        }
        String name = element.getSimpleName().toString();
        int[] ids = element.getAnnotation(BindViews.class).value();
        if (ids.length == 0) {
            this.error(element, "@%s must specify at least one ID. (%s.%s)", BindViews.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if ((duplicateId = ButterKnifeProcessor.findDuplicate(ids)) != null) {
            this.error(element, "@%s annotation contains duplicate ID %d. (%s.%s)", BindViews.class.getSimpleName(), duplicateId, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (hasError) {
            return;
        }
        assert (viewType != null);
        TypeName type = TypeName.get((TypeMirror)viewType);
        boolean required = ButterKnifeProcessor.isFieldRequired(element);
        ArrayList<Id> idVars = new ArrayList<Id>();
        for (int id : ids) {
            idVars.add(this.getId(id));
        }
        BindingClass bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        FieldCollectionViewBinding binding = new FieldCollectionViewBinding(name, type, kind, required);
        bindingClass.addFieldCollection(idVars, binding);
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceBool(Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (element.asType().getKind() != TypeKind.BOOLEAN) {
            this.error(element, "@%s field type must be 'boolean'. (%s.%s)", BindBool.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindBool.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindBool.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindBool.class).value();
        BindingClass bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        FieldResourceBinding binding = new FieldResourceBinding(this.getId(id), name, "getBoolean", false);
        bindingClass.addResource(binding);
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceColor(Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        boolean isColorStateList = false;
        TypeMirror elementType = element.asType();
        if (COLOR_STATE_LIST_TYPE.equals(elementType.toString())) {
            isColorStateList = true;
        } else if (elementType.getKind() != TypeKind.INT) {
            this.error(element, "@%s field type must be 'int' or 'ColorStateList'. (%s.%s)", BindColor.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindColor.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindColor.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindColor.class).value();
        BindingClass bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        FieldResourceBinding binding = new FieldResourceBinding(this.getId(id), name, isColorStateList ? "getColorStateList" : "getColor", true);
        bindingClass.addResource(binding);
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceDimen(Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        boolean isInt = false;
        TypeMirror elementType = element.asType();
        if (elementType.getKind() == TypeKind.INT) {
            isInt = true;
        } else if (elementType.getKind() != TypeKind.FLOAT) {
            this.error(element, "@%s field type must be 'int' or 'float'. (%s.%s)", BindDimen.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindDimen.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindDimen.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindDimen.class).value();
        BindingClass bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        FieldResourceBinding binding = new FieldResourceBinding(this.getId(id), name, isInt ? "getDimensionPixelSize" : "getDimension", false);
        bindingClass.addResource(binding);
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceBitmap(Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (!BITMAP_TYPE.equals(element.asType().toString())) {
            this.error(element, "@%s field type must be 'Bitmap'. (%s.%s)", BindBitmap.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindBitmap.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindBitmap.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindBitmap.class).value();
        BindingClass bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        FieldBitmapBinding binding = new FieldBitmapBinding(this.getId(id), name);
        bindingClass.addBitmap(binding);
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceDrawable(Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (!DRAWABLE_TYPE.equals(element.asType().toString())) {
            this.error(element, "@%s field type must be 'Drawable'. (%s.%s)", BindDrawable.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindDrawable.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindDrawable.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindDrawable.class).value();
        int tint = element.getAnnotation(BindDrawable.class).tint();
        BindingClass bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        FieldDrawableBinding binding = new FieldDrawableBinding(this.getId(id), name, this.getId(tint));
        bindingClass.addDrawable(binding);
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceInt(Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (element.asType().getKind() != TypeKind.INT) {
            this.error(element, "@%s field type must be 'int'. (%s.%s)", BindInt.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindInt.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindInt.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindInt.class).value();
        BindingClass bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        FieldResourceBinding binding = new FieldResourceBinding(this.getId(id), name, "getInteger", false);
        bindingClass.addResource(binding);
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceString(Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (!STRING_TYPE.equals(element.asType().toString())) {
            this.error(element, "@%s field type must be 'String'. (%s.%s)", BindString.class.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindString.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindString.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindString.class).value();
        BindingClass bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        FieldResourceBinding binding = new FieldResourceBinding(this.getId(id), name, "getString", false);
        bindingClass.addResource(binding);
        erasedTargetNames.add(enclosingElement);
    }

    private void parseResourceArray(Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        boolean hasError = false;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        String methodName = ButterKnifeProcessor.getArrayResourceMethodName(element);
        if (methodName == null) {
            this.error(element, "@%s field type must be one of: String[], int[], CharSequence[], %s. (%s.%s)", BindArray.class.getSimpleName(), TYPED_ARRAY_TYPE, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        hasError |= this.isInaccessibleViaGeneratedCode(BindArray.class, "fields", element);
        if (hasError |= this.isBindingInWrongPackage(BindArray.class, element)) {
            return;
        }
        String name = element.getSimpleName().toString();
        int id = element.getAnnotation(BindArray.class).value();
        BindingClass bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        FieldResourceBinding binding = new FieldResourceBinding(this.getId(id), name, methodName, false);
        bindingClass.addResource(binding);
        erasedTargetNames.add(enclosingElement);
    }

    private static String getArrayResourceMethodName(Element element) {
        TypeMirror typeMirror = element.asType();
        if (TYPED_ARRAY_TYPE.equals(typeMirror.toString())) {
            return "obtainTypedArray";
        }
        if (TypeKind.ARRAY.equals((Object)typeMirror.getKind())) {
            ArrayType arrayType = (ArrayType)typeMirror;
            String componentType = arrayType.getComponentType().toString();
            if (STRING_TYPE.equals(componentType)) {
                return "getStringArray";
            }
            if ("int".equals(componentType)) {
                return "getIntArray";
            }
            if ("java.lang.CharSequence".equals(componentType)) {
                return "getTextArray";
            }
        }
        return null;
    }

    private static Integer findDuplicate(int[] array) {
        LinkedHashSet<Integer> seenElements = new LinkedHashSet<Integer>();
        for (int element : array) {
            if (seenElements.add(element)) continue;
            return element;
        }
        return null;
    }

    private String doubleErasure(TypeMirror elementType) {
        String name = this.typeUtils.erasure(elementType).toString();
        int typeParamStart = name.indexOf(60);
        if (typeParamStart != -1) {
            name = name.substring(0, typeParamStart);
        }
        return name;
    }

    private void findAndParseListener(RoundEnvironment env, Class<? extends Annotation> annotationClass, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) {
        for (Element element : env.getElementsAnnotatedWith(annotationClass)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseListenerAnnotation(annotationClass, element, targetClassMap, erasedTargetNames);
            }
            catch (Exception e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                this.error(element, "Unable to generate view binder for @%s.\n\n%s", annotationClass.getSimpleName(), stackTrace.toString());
            }
        }
    }

    private void parseListenerAnnotation(Class<? extends Annotation> annotationClass, Element element, Map<TypeElement, BindingClass> targetClassMap, Set<TypeElement> erasedTargetNames) throws Exception {
        TypeMirror returnType;
        ListenerMethod method;
        ListenerClass listener;
        if (!(element instanceof ExecutableElement) || element.getKind() != ElementKind.METHOD) {
            throw new IllegalStateException(String.format("@%s annotation must be on a method.", annotationClass.getSimpleName()));
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        Annotation annotation = element.getAnnotation(annotationClass);
        Method annotationValue = annotationClass.getDeclaredMethod("value", new Class[0]);
        if (annotationValue.getReturnType() != int[].class) {
            throw new IllegalStateException(String.format("@%s annotation value() type not int[].", annotationClass));
        }
        int[] ids = (int[])annotationValue.invoke((Object)annotation, new Object[0]);
        String name = executableElement.getSimpleName().toString();
        boolean required = ButterKnifeProcessor.isListenerRequired(executableElement);
        boolean hasError = this.isInaccessibleViaGeneratedCode(annotationClass, "methods", element);
        hasError |= this.isBindingInWrongPackage(annotationClass, element);
        Integer duplicateId = ButterKnifeProcessor.findDuplicate(ids);
        if (duplicateId != null) {
            this.error(element, "@%s annotation for method contains duplicate ID %d. (%s.%s)", annotationClass.getSimpleName(), duplicateId, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if ((listener = annotationClass.getAnnotation(ListenerClass.class)) == null) {
            throw new IllegalStateException(String.format("No @%s defined on @%s.", ListenerClass.class.getSimpleName(), annotationClass.getSimpleName()));
        }
        for (int id : ids) {
            if (id != ButterKnifeProcessor.NO_ID.value) continue;
            if (ids.length == 1) {
                if (required) continue;
                this.error(element, "ID-free binding must not be annotated with @Optional. (%s.%s)", enclosingElement.getQualifiedName(), element.getSimpleName());
                hasError = true;
                continue;
            }
            this.error(element, "@%s annotation contains invalid ID %d. (%s.%s)", annotationClass.getSimpleName(), id, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        ListenerMethod[] methods = listener.method();
        if (methods.length > 1) {
            throw new IllegalStateException(String.format("Multiple listener methods specified on @%s.", annotationClass.getSimpleName()));
        }
        if (methods.length == 1) {
            if (listener.callbacks() != ListenerClass.NONE.class) {
                throw new IllegalStateException(String.format("Both method() and callback() defined on @%s.", annotationClass.getSimpleName()));
            }
            method = methods[0];
        } else {
            Method annotationCallback = annotationClass.getDeclaredMethod("callback", new Class[0]);
            Enum callback = (Enum)annotationCallback.invoke((Object)annotation, new Object[0]);
            Field callbackField = callback.getDeclaringClass().getField(callback.name());
            method = callbackField.getAnnotation(ListenerMethod.class);
            if (method == null) {
                throw new IllegalStateException(String.format("No @%s defined on @%s's %s.%s.", ListenerMethod.class.getSimpleName(), annotationClass.getSimpleName(), callback.getDeclaringClass().getSimpleName(), callback.name()));
            }
        }
        List<? extends VariableElement> methodParameters = executableElement.getParameters();
        if (methodParameters.size() > method.parameters().length) {
            this.error(element, "@%s methods can have at most %s parameter(s). (%s.%s)", annotationClass.getSimpleName(), method.parameters().length, enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if ((returnType = executableElement.getReturnType()) instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)returnType;
            returnType = typeVariable.getUpperBound();
        }
        if (!returnType.toString().equals(method.returnType())) {
            this.error(element, "@%s methods must have a '%s' return type. (%s.%s)", annotationClass.getSimpleName(), method.returnType(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (hasError) {
            return;
        }
        Parameter[] parameters = Parameter.NONE;
        if (!methodParameters.isEmpty()) {
            parameters = new Parameter[methodParameters.size()];
            BitSet methodParameterUsed = new BitSet(methodParameters.size());
            String[] parameterTypes = method.parameters();
            for (int i = 0; i < methodParameters.size(); ++i) {
                VariableElement methodParameter = methodParameters.get(i);
                TypeMirror methodParameterType = methodParameter.asType();
                if (methodParameterType instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)methodParameterType;
                    methodParameterType = typeVariable.getUpperBound();
                }
                for (int j = 0; j < parameterTypes.length; ++j) {
                    if (methodParameterUsed.get(j) || !this.isSubtypeOfType(methodParameterType, parameterTypes[j]) && !this.isInterface(methodParameterType)) continue;
                    parameters[i] = new Parameter(j, TypeName.get((TypeMirror)methodParameterType));
                    methodParameterUsed.set(j);
                    break;
                }
                if (parameters[i] != null) continue;
                StringBuilder builder = new StringBuilder();
                builder.append("Unable to match @").append(annotationClass.getSimpleName()).append(" method arguments. (").append(enclosingElement.getQualifiedName()).append('.').append(element.getSimpleName()).append(')');
                for (int j = 0; j < parameters.length; ++j) {
                    Parameter parameter = parameters[j];
                    builder.append("\n\n  Parameter #").append(j + 1).append(": ").append(methodParameters.get(j).asType().toString()).append("\n    ");
                    if (parameter == null) {
                        builder.append("did not match any listener parameters");
                        continue;
                    }
                    builder.append("matched listener parameter #").append(parameter.getListenerPosition() + 1).append(": ").append(parameter.getType());
                }
                builder.append("\n\nMethods may have up to ").append(method.parameters().length).append(" parameter(s):\n");
                for (String parameterType : method.parameters()) {
                    builder.append("\n  ").append(parameterType);
                }
                builder.append("\n\nThese may be listed in any order but will be searched for from top to bottom.");
                this.error(executableElement, builder.toString(), new Object[0]);
                return;
            }
        }
        MethodViewBinding binding = new MethodViewBinding(name, Arrays.asList(parameters), required);
        BindingClass bindingClass = this.getOrCreateTargetClass(targetClassMap, enclosingElement);
        for (int id : ids) {
            if (bindingClass.addMethod(this.getId(id), listener, method, binding)) continue;
            this.error(element, "Multiple listener methods with return value specified for ID %d. (%s.%s)", id, enclosingElement.getQualifiedName(), element.getSimpleName());
            return;
        }
        erasedTargetNames.add(enclosingElement);
    }

    private boolean isInterface(TypeMirror typeMirror) {
        return typeMirror instanceof DeclaredType && ((DeclaredType)typeMirror).asElement().getKind() == ElementKind.INTERFACE;
    }

    private boolean isSubtypeOfType(TypeMirror typeMirror, String otherType) {
        Element element;
        if (otherType.equals(typeMirror.toString())) {
            return true;
        }
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() > 0) {
            StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
            typeString.append('<');
            for (int i = 0; i < typeArguments.size(); ++i) {
                if (i > 0) {
                    typeString.append(',');
                }
                typeString.append('?');
            }
            typeString.append('>');
            if (typeString.toString().equals(otherType)) {
                return true;
            }
        }
        if (!((element = declaredType.asElement()) instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superType = typeElement.getSuperclass();
        if (this.isSubtypeOfType(superType, otherType)) {
            return true;
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            if (!this.isSubtypeOfType(typeMirror2, otherType)) continue;
            return true;
        }
        return false;
    }

    private BindingClass getOrCreateTargetClass(Map<TypeElement, BindingClass> targetClassMap, TypeElement enclosingElement) {
        BindingClass bindingClass = targetClassMap.get(enclosingElement);
        if (bindingClass == null) {
            TypeName targetType = TypeName.get((TypeMirror)enclosingElement.asType());
            if (targetType instanceof ParameterizedTypeName) {
                targetType = ((ParameterizedTypeName)targetType).rawType;
            }
            String packageName = this.getPackageName(enclosingElement);
            String className = ButterKnifeProcessor.getClassName(enclosingElement, packageName);
            ClassName bindingClassName = ClassName.get((String)packageName, (String)(className + "_ViewBinding"), (String[])new String[0]);
            boolean isFinal = enclosingElement.getModifiers().contains((Object)Modifier.FINAL);
            bindingClass = new BindingClass(targetType, bindingClassName, isFinal);
            targetClassMap.put(enclosingElement, bindingClass);
        }
        return bindingClass;
    }

    private static String getClassName(TypeElement type, String packageName) {
        int packageLen = packageName.length() + 1;
        return type.getQualifiedName().toString().substring(packageLen).replace('.', '$');
    }

    private TypeElement findParentType(TypeElement typeElement, Set<TypeElement> parents) {
        TypeMirror type;
        do {
            if ((type = typeElement.getSuperclass()).getKind() != TypeKind.NONE) continue;
            return null;
        } while (!parents.contains(typeElement = (TypeElement)((DeclaredType)type).asElement()));
        return typeElement;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void error(Element element, String message, Object ... args) {
        this.printMessage(Diagnostic.Kind.ERROR, element, message, args);
    }

    private void note(Element element, String message, Object ... args) {
        this.printMessage(Diagnostic.Kind.NOTE, element, message, args);
    }

    private void printMessage(Diagnostic.Kind kind, Element element, String message, Object[] args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.processingEnv.getMessager().printMessage(kind, message, element);
    }

    private String getPackageName(TypeElement type) {
        return this.elementUtils.getPackageOf(type).getQualifiedName().toString();
    }

    private static boolean hasAnnotationWithName(Element element, String simpleName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annotationName = annotationMirror.getAnnotationType().asElement().getSimpleName().toString();
            if (!simpleName.equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFieldRequired(Element element) {
        return !ButterKnifeProcessor.hasAnnotationWithName(element, NULLABLE_ANNOTATION_NAME);
    }

    private static boolean isListenerRequired(ExecutableElement element) {
        return element.getAnnotation(Optional.class) == null;
    }

    private static AnnotationMirror getMirror(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotation.getCanonicalName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private Id getId(int id) {
        if (this.symbols.get(id) == null) {
            this.symbols.put(id, new Id(id));
        }
        return this.symbols.get(id);
    }

    private void scanForRClasses(RoundEnvironment env) {
        if (this.trees == null) {
            return;
        }
        RClassScanner scanner = new RClassScanner();
        for (Class<? extends Annotation> annotation : this.getSupportedAnnotations()) {
            for (Element element : env.getElementsAnnotatedWith(annotation)) {
                JCTree tree = (JCTree)this.trees.getTree(element, ButterKnifeProcessor.getMirror(element, annotation));
                if (tree == null) continue;
                tree.accept(scanner);
            }
        }
        for (String rClass : scanner.getRClasses()) {
            this.parseRClass(rClass);
        }
    }

    private void parseRClass(String rClass) {
        Element element;
        try {
            element = this.elementUtils.getTypeElement(rClass);
        }
        catch (MirroredTypeException mte) {
            element = this.typeUtils.asElement(mte.getTypeMirror());
        }
        JCTree tree = (JCTree)this.trees.getTree(element);
        if (tree != null) {
            IdScanner idScanner = new IdScanner(this.symbols, this.elementUtils.getPackageOf(element).getQualifiedName().toString());
            tree.accept(idScanner);
        } else {
            this.parseCompiledR((TypeElement)element);
        }
    }

    private void parseCompiledR(TypeElement rClass) {
        for (Element element : rClass.getEnclosedElements()) {
            String innerClassName = element.getSimpleName().toString();
            if (!SUPPORTED_TYPES.contains(innerClassName)) continue;
            for (Element element2 : element.getEnclosedElements()) {
                VariableElement variableElement;
                Object value;
                if (!(element2 instanceof VariableElement) || !((value = (variableElement = (VariableElement)element2).getConstantValue()) instanceof Integer)) continue;
                int id = (Integer)value;
                ClassName rClassName = ClassName.get((String)this.elementUtils.getPackageOf(variableElement).toString(), (String)R, (String[])new String[]{innerClassName});
                String resourceName = variableElement.getSimpleName().toString();
                this.symbols.put(id, new Id(id, rClassName, resourceName));
            }
        }
    }

    private static class VarScanner
    extends TreeScanner {
        private final Map<Integer, Id> ids;
        private final ClassName className;

        private VarScanner(Map<Integer, Id> ids, ClassName className) {
            this.ids = ids;
            this.className = className;
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jcVariableDecl) {
            if ("int".equals(jcVariableDecl.getType().toString())) {
                int id = Integer.valueOf(jcVariableDecl.getInitializer().toString());
                String resourceName = jcVariableDecl.getName().toString();
                this.ids.put(id, new Id(id, this.className, resourceName));
            }
        }
    }

    private static class IdScanner
    extends TreeScanner {
        private final Map<Integer, Id> ids;
        private final String packageName;

        IdScanner(Map<Integer, Id> ids, String packageName) {
            this.ids = ids;
            this.packageName = packageName;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jcClassDecl) {
            for (JCTree tree : jcClassDecl.defs) {
                if (!(tree instanceof ClassTree)) continue;
                ClassTree classTree = (ClassTree)((Object)tree);
                String className = classTree.getSimpleName().toString();
                if (!SUPPORTED_TYPES.contains(className)) continue;
                ClassName rClassName = ClassName.get((String)this.packageName, (String)ButterKnifeProcessor.R, (String[])new String[]{className});
                VarScanner scanner = new VarScanner(this.ids, rClassName);
                ((JCTree)((Object)classTree)).accept(scanner);
            }
        }
    }

    private static class RClassScanner
    extends TreeScanner {
        private final Set<String> rClasses = new LinkedHashSet<String>();

        private RClassScanner() {
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jcFieldAccess) {
            Symbol symbol = jcFieldAccess.sym;
            if (symbol != null && symbol.getEnclosingElement() != null && symbol.getEnclosingElement().getEnclosingElement() != null && symbol.getEnclosingElement().getEnclosingElement().enclClass() != null) {
                this.rClasses.add(symbol.getEnclosingElement().getEnclosingElement().enclClass().className());
            }
        }

        Set<String> getRClasses() {
            return this.rClasses;
        }
    }
}

