/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.design.widget;

import android.support.design.widget.AppBarLayout;
import com.jakewharton.rxbinding.internal.Preconditions;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class AppBarLayoutOffsetChangeOnSubscribe
implements Observable.OnSubscribe<Integer> {
    final AppBarLayout view;

    AppBarLayoutOffsetChangeOnSubscribe(AppBarLayout view) {
        this.view = view;
    }

    public void call(final Subscriber<? super Integer> subscriber) {
        Preconditions.checkUiThread();
        final AppBarLayout.OnOffsetChangedListener listener = new AppBarLayout.OnOffsetChangedListener(){

            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)verticalOffset);
                }
            }
        };
        this.view.addOnOffsetChangedListener(listener);
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                AppBarLayoutOffsetChangeOnSubscribe.this.view.removeOnOffsetChangedListener(listener);
            }
        });
    }
}

