/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.design.widget;

import android.support.design.widget.NavigationView;
import android.view.Menu;
import android.view.MenuItem;
import com.jakewharton.rxbinding.internal.Preconditions;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class NavigationViewItemSelectionsOnSubscribe
implements Observable.OnSubscribe<MenuItem> {
    final NavigationView view;

    NavigationViewItemSelectionsOnSubscribe(NavigationView view) {
        this.view = view;
    }

    public void call(final Subscriber<? super MenuItem> subscriber) {
        Preconditions.checkUiThread();
        NavigationView.OnNavigationItemSelectedListener listener = new NavigationView.OnNavigationItemSelectedListener(){

            public boolean onNavigationItemSelected(MenuItem menuItem) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)menuItem);
                }
                return true;
            }
        };
        this.view.setNavigationItemSelectedListener(listener);
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                NavigationViewItemSelectionsOnSubscribe.this.view.setNavigationItemSelectedListener(null);
            }
        });
        Menu menu = this.view.getMenu();
        int count = menu.size();
        for (int i = 0; i < count; ++i) {
            MenuItem item = menu.getItem(i);
            if (!item.isChecked()) continue;
            subscriber.onNext((Object)item);
            break;
        }
    }
}

