/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.design.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.design.widget.TabLayout;
import com.jakewharton.rxbinding.internal.Preconditions;
import com.jakewharton.rxbinding.support.design.widget.TabLayoutSelectionEvent;
import com.jakewharton.rxbinding.support.design.widget.TabLayoutSelectionEventOnSubscribe;
import com.jakewharton.rxbinding.support.design.widget.TabLayoutSelectionsOnSubscribe;
import rx.Observable;
import rx.functions.Action1;

public final class RxTabLayout {
    @CheckResult
    @NonNull
    public static Observable<TabLayout.Tab> selections(@NonNull TabLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return Observable.create((Observable.OnSubscribe)new TabLayoutSelectionsOnSubscribe(view));
    }

    @CheckResult
    @NonNull
    public static Observable<TabLayoutSelectionEvent> selectionEvents(@NonNull TabLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return Observable.create((Observable.OnSubscribe)new TabLayoutSelectionEventOnSubscribe(view));
    }

    @CheckResult
    @NonNull
    public static Action1<? super Integer> select(final @NonNull TabLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<Integer>(){

            public void call(Integer index) {
                if (index < 0 || index >= view.getTabCount()) {
                    throw new IllegalArgumentException("No tab for index " + index);
                }
                view.getTabAt(index.intValue()).select();
            }
        };
    }

    private RxTabLayout() {
        throw new AssertionError((Object)"No instances.");
    }
}

