/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.design.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.design.widget.TextInputLayout;
import com.jakewharton.rxbinding.internal.Preconditions;
import rx.functions.Action1;

public final class RxTextInputLayout {
    @CheckResult
    @NonNull
    public static Action1<? super Boolean> counterEnabled(final @NonNull TextInputLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<Boolean>(){

            public void call(Boolean enable) {
                view.setCounterEnabled(enable.booleanValue());
            }
        };
    }

    @CheckResult
    @NonNull
    public static Action1<? super Integer> counterMaxLength(final @NonNull TextInputLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<Integer>(){

            public void call(Integer maxLength) {
                view.setCounterMaxLength(maxLength.intValue());
            }
        };
    }

    @CheckResult
    @NonNull
    public static Action1<? super CharSequence> error(final @NonNull TextInputLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<CharSequence>(){

            public void call(CharSequence error) {
                view.setError(error);
            }
        };
    }

    @CheckResult
    @NonNull
    public static Action1<? super Integer> errorRes(final @NonNull TextInputLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<Integer>(){

            public void call(Integer errorRes) {
                view.setError(view.getContext().getResources().getText(errorRes.intValue()));
            }
        };
    }

    @CheckResult
    @NonNull
    public static Action1<? super CharSequence> hint(final @NonNull TextInputLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<CharSequence>(){

            public void call(CharSequence hint) {
                view.setHint(hint);
            }
        };
    }

    @CheckResult
    @NonNull
    public static Action1<? super Integer> hintRes(final @NonNull TextInputLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<Integer>(){

            public void call(Integer hintRes) {
                view.setHint(view.getContext().getResources().getText(hintRes.intValue()));
            }
        };
    }

    private RxTextInputLayout() {
        throw new AssertionError((Object)"No instances.");
    }
}

