/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.design.widget;

import android.support.design.widget.Snackbar;
import com.jakewharton.rxbinding.internal.Preconditions;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class SnackbarDismissesOnSubscribe
implements Observable.OnSubscribe<Integer> {
    final Snackbar view;

    SnackbarDismissesOnSubscribe(Snackbar view) {
        this.view = view;
    }

    public void call(final Subscriber<? super Integer> subscriber) {
        Preconditions.checkUiThread();
        Snackbar.Callback callback = new Snackbar.Callback(){

            public void onDismissed(Snackbar snackbar, int event) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)event);
                }
            }
        };
        this.view.setCallback(callback);
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                SnackbarDismissesOnSubscribe.this.view.setCallback(null);
            }
        });
    }
}

