/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.design.widget;

import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.SwipeDismissBehavior;
import android.view.View;
import com.jakewharton.rxbinding.internal.Preconditions;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class SwipeDismissBehaviorOnSubscribe
implements Observable.OnSubscribe<View> {
    private final View view;

    public SwipeDismissBehaviorOnSubscribe(View view) {
        this.view = view;
    }

    public void call(final Subscriber<? super View> subscriber) {
        Preconditions.checkUiThread();
        SwipeDismissBehavior.OnDismissListener listener = new SwipeDismissBehavior.OnDismissListener(){

            public void onDismiss(View view) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)view);
                }
            }

            public void onDragStateChanged(int i) {
            }
        };
        if (!(this.view.getLayoutParams() instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not in a Coordinator Layout.");
        }
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)this.view.getLayoutParams();
        final SwipeDismissBehavior behavior = (SwipeDismissBehavior)params.getBehavior();
        if (behavior == null) {
            throw new IllegalStateException("There's no behavior set on this view.");
        }
        behavior.setListener(listener);
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                behavior.setListener(null);
            }
        });
    }
}

