/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.design.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.design.widget.TabLayout;
import android.view.View;
import com.jakewharton.rxbinding.view.ViewEvent;

public final class TabLayoutSelectionEvent
extends ViewEvent<TabLayout> {
    private final Kind kind;
    private final TabLayout.Tab tab;

    @CheckResult
    @NonNull
    public static TabLayoutSelectionEvent create(@NonNull TabLayout view, @NonNull Kind kind, @NonNull TabLayout.Tab tab) {
        return new TabLayoutSelectionEvent(view, kind, tab);
    }

    private TabLayoutSelectionEvent(@NonNull TabLayout view, @NonNull Kind kind, @NonNull TabLayout.Tab tab) {
        super((View)view);
        this.tab = tab;
        this.kind = kind;
    }

    @NonNull
    public Kind kind() {
        return this.kind;
    }

    @NonNull
    public TabLayout.Tab tab() {
        return this.tab;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabLayoutSelectionEvent)) {
            return false;
        }
        TabLayoutSelectionEvent other = (TabLayoutSelectionEvent)((Object)o);
        return this.view() == other.view() && this.kind == other.kind && this.tab == other.tab;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + ((TabLayout)this.view()).hashCode();
        result = result * 37 + this.kind.hashCode();
        result = result * 37 + this.tab.hashCode();
        return result;
    }

    public String toString() {
        return "ViewTouchEvent{view=" + this.view() + ", kind=" + (Object)((Object)this.kind) + ", tab=" + this.tab + '}';
    }

    public static enum Kind {
        SELECTED,
        RESELECTED,
        UNSELECTED;

    }
}

