/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.design.widget;

import android.support.design.widget.TabLayout;
import com.jakewharton.rxbinding.internal.Preconditions;
import com.jakewharton.rxbinding.support.design.widget.TabLayoutSelectionEvent;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class TabLayoutSelectionEventOnSubscribe
implements Observable.OnSubscribe<TabLayoutSelectionEvent> {
    final TabLayout view;

    TabLayoutSelectionEventOnSubscribe(TabLayout view) {
        this.view = view;
    }

    public void call(final Subscriber<? super TabLayoutSelectionEvent> subscriber) {
        Preconditions.checkUiThread();
        TabLayout.OnTabSelectedListener listener = new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)TabLayoutSelectionEvent.create(TabLayoutSelectionEventOnSubscribe.this.view, TabLayoutSelectionEvent.Kind.SELECTED, tab));
                }
            }

            public void onTabUnselected(TabLayout.Tab tab) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)TabLayoutSelectionEvent.create(TabLayoutSelectionEventOnSubscribe.this.view, TabLayoutSelectionEvent.Kind.UNSELECTED, tab));
                }
            }

            public void onTabReselected(TabLayout.Tab tab) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)TabLayoutSelectionEvent.create(TabLayoutSelectionEventOnSubscribe.this.view, TabLayoutSelectionEvent.Kind.RESELECTED, tab));
                }
            }
        };
        this.view.setOnTabSelectedListener(listener);
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                TabLayoutSelectionEventOnSubscribe.this.view.setOnTabSelectedListener(null);
            }
        });
        int index = this.view.getSelectedTabPosition();
        if (index != -1) {
            subscriber.onNext((Object)TabLayoutSelectionEvent.create(this.view, TabLayoutSelectionEvent.Kind.SELECTED, this.view.getTabAt(index)));
        }
    }
}

