/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.design.widget;

import android.support.design.widget.TabLayout;
import com.jakewharton.rxbinding.internal.Preconditions;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class TabLayoutSelectionsOnSubscribe
implements Observable.OnSubscribe<TabLayout.Tab> {
    final TabLayout view;

    TabLayoutSelectionsOnSubscribe(TabLayout view) {
        this.view = view;
    }

    public void call(final Subscriber<? super TabLayout.Tab> subscriber) {
        Preconditions.checkUiThread();
        TabLayout.OnTabSelectedListener listener = new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)tab);
                }
            }

            public void onTabUnselected(TabLayout.Tab tab) {
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        };
        this.view.setOnTabSelectedListener(listener);
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                TabLayoutSelectionsOnSubscribe.this.view.setOnTabSelectedListener(null);
            }
        });
        int index = this.view.getSelectedTabPosition();
        if (index != -1) {
            subscriber.onNext((Object)this.view.getTabAt(index));
        }
    }
}

