/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.CompositeListener;
import com.jamonapi.CopyJAMonListener;
import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonListener;
import com.jamonapi.utils.BufferList;
import com.jamonapi.utils.Misc;
import java.util.Iterator;
import java.util.Map;

public class JAMonListenerFactory {
    private static String[] HEADER = new String[]{"ListenerName", "Listener"};
    private static Map map = Misc.createCaseInsensitiveMap();

    public static void put(JAMonListener jamonListener) {
        map.put(jamonListener.getName(), jamonListener);
    }

    public static Object[][] getData() {
        Iterator iter = map.entrySet().iterator();
        Object[][] data = new Object[map.size()][];
        int i = 0;
        while (iter.hasNext()) {
            data[i] = new Object[2];
            Map.Entry entry = iter.next();
            data[i][0] = entry.getKey();
            data[i][1] = entry.getValue();
            ++i;
        }
        return data;
    }

    public static String[] getHeader() {
        return HEADER;
    }

    public static JAMonListener get(String listenerName) {
        try {
            JAMonListener factoryInstance = (JAMonListener)map.get(listenerName);
            if (factoryInstance instanceof CopyJAMonListener) {
                return ((CopyJAMonListener)((Object)factoryInstance)).copy();
            }
            JAMonListener newInst = (JAMonListener)factoryInstance.getClass().newInstance();
            newInst.setName(factoryInstance.getName());
            return newInst;
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting listener from factory: " + listenerName + ", " + e);
        }
    }

    public static void main(String[] args) {
        JAMonListenerFactory.put(new CompositeListener("tester"));
        JAMonListenerFactory.put(new JAMonBufferListener("helloListener", new BufferList(new String[]{"hey"}, 200)));
        String[] header = JAMonListenerFactory.getHeader();
        Object[][] data = JAMonListenerFactory.getData();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                System.out.println(header[j] + "=" + data[i][j]);
            }
        }
        System.out.println("\ngetting listener=" + JAMonListenerFactory.get("JAMonBufferListener"));
        JAMonBufferListener jbl = (JAMonBufferListener)JAMonListenerFactory.get("helloListener");
        System.out.println("name=" + jbl.getName() + ", buffer=" + jbl.getBufferList().getBufferSize());
    }

    static {
        JAMonBufferListener factoryInstance = new JAMonBufferListener();
        JAMonListenerFactory.put(factoryInstance);
    }
}

