/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.internal.http;

import com.jayway.restassured.authentication.OAuthSignature;
import com.jayway.restassured.internal.KeystoreSpecImpl;
import com.jayway.restassured.internal.http.HTTPBuilder;
import com.jayway.restassured.internal.http.URIBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.Map;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthRequest;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuth10aServiceImpl;
import org.scribe.oauth.OAuth20ServiceImpl;
import org.scribe.oauth.OAuthService;

public class AuthConfig {
    private static final int UNDEFINED_PORT = -1;
    private static final int DEFAULT_HTTPS_PORT = 443;
    protected HTTPBuilder builder;

    public AuthConfig(HTTPBuilder builder) {
        this.builder = builder;
    }

    public void basic(String user, String pass) {
        URI uri = ((URIBuilder)this.builder.getUri()).toURI();
        if (uri == null) {
            throw new IllegalStateException("a default URI must be set");
        }
        this.basic(uri.getHost(), uri.getPort(), user, pass);
    }

    public void basic(String host, int port, String user, String pass) {
        this.builder.getClient().getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(user, pass));
    }

    public void certificate(String certURL, String password, String certType, int port, KeyStore trustStore, X509HostnameVerifier x509HostnameVerifier, SSLSocketFactory sslSocketFactory) {
        KeystoreSpecImpl keystoreSpec = new KeystoreSpecImpl();
        URI uri = ((URIBuilder)this.builder.getUri()).toURI();
        if (uri == null) {
            throw new IllegalStateException("a default URI must be set");
        }
        keystoreSpec.setKeyStoreType(certType);
        keystoreSpec.setPassword(password);
        keystoreSpec.setPath(certURL);
        keystoreSpec.setTrustStore(trustStore);
        keystoreSpec.setPort(port);
        keystoreSpec.setX509HostnameVerifier(x509HostnameVerifier);
        keystoreSpec.setFactory(sslSocketFactory);
        int portSpecifiedInUri = uri.getPort();
        keystoreSpec.apply(this.builder, portSpecifiedInUri == -1 ? 443 : portSpecifiedInUri);
    }

    public void oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
        this.builder.client.removeRequestInterceptorByClass(OAuthSigner.class);
        if (consumerKey != null) {
            this.builder.client.addRequestInterceptor((HttpRequestInterceptor)new OAuthSigner(consumerKey, consumerSecret, accessToken, secretToken, OAuthSignature.HEADER));
        }
    }

    public void oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken, OAuthSignature signature) {
        this.builder.client.removeRequestInterceptorByClass(OAuthSigner.class);
        if (consumerKey != null) {
            this.builder.client.addRequestInterceptor((HttpRequestInterceptor)new OAuthSigner(consumerKey, consumerSecret, accessToken, secretToken, signature));
        }
    }

    public void oauth2(String accessToken) {
        this.builder.client.removeRequestInterceptorByClass(OAuthSigner.class);
        if (accessToken != null) {
            this.builder.client.addRequestInterceptor((HttpRequestInterceptor)new OAuthSigner(accessToken, OAuthSignature.HEADER));
        }
    }

    public void oauth2(String accessToken, OAuthSignature signature) {
        this.builder.client.removeRequestInterceptorByClass(OAuthSigner.class);
        if (accessToken != null) {
            this.builder.client.addRequestInterceptor((HttpRequestInterceptor)new OAuthSigner(accessToken, signature));
        }
    }

    static class OAuthSigner
    implements HttpRequestInterceptor {
        protected OAuthConfig oauthConfig;
        protected Token token;
        protected OAuthService service;
        protected SignatureType type = SignatureType.Header;
        protected OAuthSignature signature;
        protected boolean oauth1 = true;

        public OAuthSigner(String consumerKey, String consumerSecret, String accessToken, String secretToken, OAuthSignature signature) {
            this.oauthConfig = new OAuthConfig(consumerKey, consumerSecret, null, OAuthSigner.getOAuthSigntureType(signature), null, null);
            this.token = new Token(accessToken, secretToken);
            this.signature = signature;
        }

        public OAuthSigner(String accessToken, OAuthSignature signature) {
            this.token = new Token(accessToken, "");
            this.signature = signature;
            this.oauth1 = false;
        }

        public void process(HttpRequest request, HttpContext ctx) throws HttpException, IOException {
            try {
                HttpHost host = (HttpHost)ctx.getAttribute("http.target_host");
                URI requestURI = new URI(host.toURI()).resolve(request.getRequestLine().getUri());
                Verb verb = Verb.valueOf((String)request.getRequestLine().getMethod().toUpperCase());
                OAuthRequest oauthRequest = new OAuthRequest(verb, requestURI.toString());
                this.service = this.getOauthService(this.oauth1);
                this.service.signRequest(this.token, oauthRequest);
                if (this.signature == OAuthSignature.HEADER) {
                    for (Map.Entry entry : oauthRequest.getHeaders().entrySet()) {
                        request.setHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                } else {
                    URI uri = new URI(oauthRequest.getCompleteUrl());
                    ((RequestWrapper)request).setURI(uri);
                }
            }
            catch (URISyntaxException ex) {
                throw new HttpException("Error rebuilding request URI", (Throwable)ex);
            }
        }

        private OAuthService getOauthService(boolean oauth1) {
            OAuth10aServiceImpl service = null;
            if (oauth1) {
                DefaultApi10a api = new DefaultApi10a(){

                    public String getRequestTokenEndpoint() {
                        return null;
                    }

                    public String getAuthorizationUrl(Token arg0) {
                        return null;
                    }

                    public String getAccessTokenEndpoint() {
                        return null;
                    }
                };
                service = new OAuth10aServiceImpl(api, this.oauthConfig);
            } else {
                DefaultApi20 api = new DefaultApi20(){

                    public String getAuthorizationUrl(OAuthConfig arg0) {
                        return null;
                    }

                    public String getAccessTokenEndpoint() {
                        return null;
                    }
                };
                service = new OAuth20ServiceImpl(api, this.oauthConfig);
            }
            return service;
        }

        private static SignatureType getOAuthSigntureType(OAuthSignature signature) {
            SignatureType signatureType = signature == OAuthSignature.HEADER ? SignatureType.Header : SignatureType.QueryString;
            return signatureType;
        }
    }
}

