/*
 * Decompiled with CFR 0.152.
 */
package com.jcodecraeer.xrecyclerview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.jcodecraeer.xrecyclerview.AppBarStateChangeListener;
import com.jcodecraeer.xrecyclerview.ArrowRefreshHeader;
import com.jcodecraeer.xrecyclerview.LoadingMoreFooter;
import java.util.ArrayList;
import java.util.List;

public class XRecyclerView
extends RecyclerView {
    private boolean isLoadingData = false;
    private boolean isNoMore = false;
    private int mRefreshProgressStyle = -1;
    private int mLoadingMoreProgressStyle = -1;
    private ArrayList<View> mHeaderViews = new ArrayList();
    private WrapAdapter mWrapAdapter;
    private float mLastY = -1.0f;
    private static final float DRAG_RATE = 3.0f;
    private LoadingListener mLoadingListener;
    private ArrowRefreshHeader mRefreshHeader;
    private boolean pullRefreshEnabled = true;
    private boolean loadingMoreEnabled = true;
    private static final int TYPE_REFRESH_HEADER = 10000;
    private static final int TYPE_FOOTER = 10001;
    private static final int HEADER_INIT_INDEX = 10002;
    private static List<Integer> sHeaderTypes = new ArrayList<Integer>();
    private int mPageCount = 0;
    private View mEmptyView;
    private View mFootView;
    private final RecyclerView.AdapterDataObserver mDataObserver = new DataObserver();
    private AppBarStateChangeListener.State appbarState = AppBarStateChangeListener.State.EXPANDED;

    public XRecyclerView(Context context) {
        this(context, null);
    }

    public XRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        if (this.pullRefreshEnabled) {
            this.mRefreshHeader = new ArrowRefreshHeader(this.getContext());
            this.mRefreshHeader.setProgressStyle(this.mRefreshProgressStyle);
        }
        LoadingMoreFooter footView = new LoadingMoreFooter(this.getContext());
        footView.setProgressStyle(this.mLoadingMoreProgressStyle);
        this.mFootView = footView;
        this.mFootView.setVisibility(8);
    }

    public void addHeaderView(View view) {
        sHeaderTypes.add(10002 + this.mHeaderViews.size());
        this.mHeaderViews.add(view);
        if (this.mWrapAdapter != null) {
            this.mWrapAdapter.notifyDataSetChanged();
        }
    }

    private View getHeaderViewByType(int itemType) {
        if (!this.isHeaderType(itemType)) {
            return null;
        }
        return this.mHeaderViews.get(itemType - 10002);
    }

    private boolean isHeaderType(int itemViewType) {
        return this.mHeaderViews.size() > 0 && sHeaderTypes.contains(itemViewType);
    }

    private boolean isReservedItemViewType(int itemViewType) {
        return itemViewType == 10000 || itemViewType == 10001 || sHeaderTypes.contains(itemViewType);
    }

    public void setFootView(View view) {
        this.mFootView = view;
    }

    public void loadMoreComplete() {
        this.isLoadingData = false;
        if (this.mFootView instanceof LoadingMoreFooter) {
            ((LoadingMoreFooter)this.mFootView).setState(1);
        } else {
            this.mFootView.setVisibility(8);
        }
    }

    public void setNoMore(boolean noMore) {
        this.isLoadingData = false;
        this.isNoMore = noMore;
        if (this.mFootView instanceof LoadingMoreFooter) {
            ((LoadingMoreFooter)this.mFootView).setState(this.isNoMore ? 2 : 1);
        } else {
            this.mFootView.setVisibility(8);
        }
    }

    public void refresh() {
        if (this.pullRefreshEnabled && this.mLoadingListener != null) {
            this.mRefreshHeader.setState(2);
            this.mLoadingListener.onRefresh();
        }
    }

    public void reset() {
        this.setNoMore(false);
        this.loadMoreComplete();
        this.refreshComplete();
    }

    public void refreshComplete() {
        this.mRefreshHeader.refreshComplete();
        this.setNoMore(false);
    }

    public void setRefreshHeader(ArrowRefreshHeader refreshHeader) {
        this.mRefreshHeader = refreshHeader;
    }

    public void setPullRefreshEnabled(boolean enabled) {
        this.pullRefreshEnabled = enabled;
    }

    public void setLoadingMoreEnabled(boolean enabled) {
        this.loadingMoreEnabled = enabled;
        if (!enabled && this.mFootView instanceof LoadingMoreFooter) {
            ((LoadingMoreFooter)this.mFootView).setState(1);
        }
    }

    public void setRefreshProgressStyle(int style) {
        this.mRefreshProgressStyle = style;
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setProgressStyle(style);
        }
    }

    public void setLoadingMoreProgressStyle(int style) {
        this.mLoadingMoreProgressStyle = style;
        if (this.mFootView instanceof LoadingMoreFooter) {
            ((LoadingMoreFooter)this.mFootView).setProgressStyle(style);
        }
    }

    public void setArrowImageView(int resId) {
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setArrowImageView(resId);
        }
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
        this.mDataObserver.onChanged();
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.mWrapAdapter = new WrapAdapter(adapter);
        super.setAdapter((RecyclerView.Adapter)this.mWrapAdapter);
        adapter.registerAdapterDataObserver(this.mDataObserver);
        this.mDataObserver.onChanged();
    }

    public RecyclerView.Adapter getAdapter() {
        if (this.mWrapAdapter != null) {
            return this.mWrapAdapter.getOriginalAdapter();
        }
        return null;
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout2) {
        super.setLayoutManager(layout2);
        if (this.mWrapAdapter != null && layout2 instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)layout2;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    return XRecyclerView.this.mWrapAdapter.isHeader(position) || XRecyclerView.this.mWrapAdapter.isFooter(position) || XRecyclerView.this.mWrapAdapter.isRefreshHeader(position) ? gridManager.getSpanCount() : 1;
                }
            });
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (state == 0 && this.mLoadingListener != null && !this.isLoadingData && this.loadingMoreEnabled) {
            int lastVisibleItemPosition;
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            if (layoutManager instanceof GridLayoutManager) {
                lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                int[] into = new int[((StaggeredGridLayoutManager)layoutManager).getSpanCount()];
                ((StaggeredGridLayoutManager)layoutManager).findLastVisibleItemPositions(into);
                lastVisibleItemPosition = this.findMax(into);
            } else {
                lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            }
            if (layoutManager.getChildCount() > 0 && lastVisibleItemPosition >= layoutManager.getItemCount() - 1 && layoutManager.getItemCount() > layoutManager.getChildCount() && !this.isNoMore && this.mRefreshHeader.getState() < 2) {
                this.isLoadingData = true;
                if (this.mFootView instanceof LoadingMoreFooter) {
                    ((LoadingMoreFooter)this.mFootView).setState(0);
                } else {
                    this.mFootView.setVisibility(0);
                }
                this.mLoadingListener.onLoadMore();
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (!this.isOnTop() || !this.pullRefreshEnabled || this.appbarState != AppBarStateChangeListener.State.EXPANDED) break;
                this.mRefreshHeader.onMove(deltaY / 3.0f);
                if (this.mRefreshHeader.getVisibleHeight() <= 0 || this.mRefreshHeader.getState() >= 2) break;
                return false;
            }
            default: {
                this.mLastY = -1.0f;
                if (!this.isOnTop() || !this.pullRefreshEnabled || this.appbarState != AppBarStateChangeListener.State.EXPANDED || !this.mRefreshHeader.releaseAction() || this.mLoadingListener == null) break;
                this.mLoadingListener.onRefresh();
            }
        }
        return super.onTouchEvent(ev);
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private boolean isOnTop() {
        return this.mRefreshHeader.getParent() != null;
    }

    public void setLoadingListener(LoadingListener listener) {
        this.mLoadingListener = listener;
    }

    protected void onAttachedToWindow() {
        ViewParent p;
        super.onAttachedToWindow();
        AppBarLayout appBarLayout = null;
        for (p = this.getParent(); p != null && !(p instanceof CoordinatorLayout); p = p.getParent()) {
        }
        if (p instanceof CoordinatorLayout) {
            CoordinatorLayout coordinatorLayout = (CoordinatorLayout)p;
            int childCount = coordinatorLayout.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = coordinatorLayout.getChildAt(i);
                if (!(child instanceof AppBarLayout)) continue;
                appBarLayout = (AppBarLayout)child;
                break;
            }
            if (appBarLayout != null) {
                appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)new AppBarStateChangeListener(){

                    @Override
                    public void onStateChanged(AppBarLayout appBarLayout, AppBarStateChangeListener.State state) {
                        XRecyclerView.this.appbarState = state;
                    }
                });
            }
        }
    }

    public class DividerItemDecoration
    extends RecyclerView.ItemDecoration {
        private Drawable mDivider;
        private int mOrientation;

        public DividerItemDecoration(Drawable divider) {
            this.mDivider = divider;
        }

        public void onDraw(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
            if (this.mOrientation == 0) {
                this.drawHorizontalDividers(canvas, parent);
            } else if (this.mOrientation == 1) {
                this.drawVerticalDividers(canvas, parent);
            }
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            super.getItemOffsets(outRect, view, parent, state);
            if (parent.getChildAdapterPosition(view) <= XRecyclerView.this.mWrapAdapter.getHeadersCount() + 1) {
                return;
            }
            this.mOrientation = ((LinearLayoutManager)parent.getLayoutManager()).getOrientation();
            if (this.mOrientation == 0) {
                outRect.left = this.mDivider.getIntrinsicWidth();
            } else if (this.mOrientation == 1) {
                outRect.top = this.mDivider.getIntrinsicHeight();
            }
        }

        private void drawHorizontalDividers(Canvas canvas, RecyclerView parent) {
            int parentTop = parent.getPaddingTop();
            int parentBottom = parent.getHeight() - parent.getPaddingBottom();
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount - 1; ++i) {
                View child = parent.getChildAt(i);
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
                int parentLeft = child.getRight() + params.rightMargin;
                int parentRight = parentLeft + this.mDivider.getIntrinsicWidth();
                this.mDivider.setBounds(parentLeft, parentTop, parentRight, parentBottom);
                this.mDivider.draw(canvas);
            }
        }

        private void drawVerticalDividers(Canvas canvas, RecyclerView parent) {
            int parentLeft = parent.getPaddingLeft();
            int parentRight = parent.getWidth() - parent.getPaddingRight();
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount - 1; ++i) {
                View child = parent.getChildAt(i);
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
                int parentTop = child.getBottom() + params.bottomMargin;
                int parentBottom = parentTop + this.mDivider.getIntrinsicHeight();
                this.mDivider.setBounds(parentLeft, parentTop, parentRight, parentBottom);
                this.mDivider.draw(canvas);
            }
        }
    }

    public static interface LoadingListener {
        public void onRefresh();

        public void onLoadMore();
    }

    private class WrapAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private RecyclerView.Adapter adapter;

        public WrapAdapter(RecyclerView.Adapter adapter) {
            this.adapter = adapter;
        }

        public RecyclerView.Adapter getOriginalAdapter() {
            return this.adapter;
        }

        public boolean isHeader(int position) {
            return position >= 1 && position < XRecyclerView.this.mHeaderViews.size() + 1;
        }

        public boolean isFooter(int position) {
            if (XRecyclerView.this.loadingMoreEnabled) {
                return position == this.getItemCount() - 1;
            }
            return false;
        }

        public boolean isRefreshHeader(int position) {
            return position == 0;
        }

        public int getHeadersCount() {
            return XRecyclerView.this.mHeaderViews.size();
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            if (viewType == 10000) {
                return new SimpleViewHolder((View)XRecyclerView.this.mRefreshHeader);
            }
            if (XRecyclerView.this.isHeaderType(viewType)) {
                return new SimpleViewHolder(XRecyclerView.this.getHeaderViewByType(viewType));
            }
            if (viewType == 10001) {
                return new SimpleViewHolder(XRecyclerView.this.mFootView);
            }
            return this.adapter.onCreateViewHolder(parent, viewType);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            int adapterCount;
            if (this.isHeader(position) || this.isRefreshHeader(position)) {
                return;
            }
            int adjPosition = position - (this.getHeadersCount() + 1);
            if (this.adapter != null && adjPosition < (adapterCount = this.adapter.getItemCount())) {
                this.adapter.onBindViewHolder(holder, adjPosition);
            }
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
            int adapterCount;
            if (this.isHeader(position) || this.isRefreshHeader(position)) {
                return;
            }
            int adjPosition = position - (this.getHeadersCount() + 1);
            if (this.adapter != null && adjPosition < (adapterCount = this.adapter.getItemCount())) {
                if (payloads.isEmpty()) {
                    this.adapter.onBindViewHolder(holder, adjPosition);
                } else {
                    this.adapter.onBindViewHolder(holder, adjPosition, payloads);
                }
            }
        }

        public int getItemCount() {
            if (XRecyclerView.this.loadingMoreEnabled) {
                if (this.adapter != null) {
                    return this.getHeadersCount() + this.adapter.getItemCount() + 2;
                }
                return this.getHeadersCount() + 2;
            }
            if (this.adapter != null) {
                return this.getHeadersCount() + this.adapter.getItemCount() + 1;
            }
            return this.getHeadersCount() + 1;
        }

        public int getItemViewType(int position) {
            int adapterCount;
            int adjPosition = position - (this.getHeadersCount() + 1);
            if (this.isRefreshHeader(position)) {
                return 10000;
            }
            if (this.isHeader(position)) {
                return (Integer)sHeaderTypes.get(--position);
            }
            if (this.isFooter(position)) {
                return 10001;
            }
            if (this.adapter != null && adjPosition < (adapterCount = this.adapter.getItemCount())) {
                int type = this.adapter.getItemViewType(adjPosition);
                if (XRecyclerView.this.isReservedItemViewType(type)) {
                    throw new IllegalStateException("XRecyclerView require itemViewType in adapter should be less than 10000 ");
                }
                return type;
            }
            return 0;
        }

        public long getItemId(int position) {
            int adjPosition;
            if (this.adapter != null && position >= this.getHeadersCount() + 1 && (adjPosition = position - (this.getHeadersCount() + 1)) < this.adapter.getItemCount()) {
                return this.adapter.getItemId(adjPosition);
            }
            return -1L;
        }

        public void onAttachedToRecyclerView(RecyclerView recyclerView) {
            super.onAttachedToRecyclerView(recyclerView);
            RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
            if (manager instanceof GridLayoutManager) {
                final GridLayoutManager gridManager = (GridLayoutManager)manager;
                gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                    public int getSpanSize(int position) {
                        return WrapAdapter.this.isHeader(position) || WrapAdapter.this.isFooter(position) || WrapAdapter.this.isRefreshHeader(position) ? gridManager.getSpanCount() : 1;
                    }
                });
            }
            this.adapter.onAttachedToRecyclerView(recyclerView);
        }

        public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
            this.adapter.onDetachedFromRecyclerView(recyclerView);
        }

        public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
            super.onViewAttachedToWindow(holder);
            ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
            if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams && (this.isHeader(holder.getLayoutPosition()) || this.isRefreshHeader(holder.getLayoutPosition()) || this.isFooter(holder.getLayoutPosition()))) {
                StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
                p.setFullSpan(true);
            }
            this.adapter.onViewAttachedToWindow(holder);
        }

        public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
            this.adapter.onViewDetachedFromWindow(holder);
        }

        public void onViewRecycled(RecyclerView.ViewHolder holder) {
            this.adapter.onViewRecycled(holder);
        }

        public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
            return this.adapter.onFailedToRecycleView(holder);
        }

        public void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
            this.adapter.unregisterAdapterDataObserver(observer);
        }

        public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
            this.adapter.registerAdapterDataObserver(observer);
        }

        private class SimpleViewHolder
        extends RecyclerView.ViewHolder {
            public SimpleViewHolder(View itemView) {
                super(itemView);
            }
        }
    }

    private class DataObserver
    extends RecyclerView.AdapterDataObserver {
        private DataObserver() {
        }

        public void onChanged() {
            if (XRecyclerView.this.mWrapAdapter != null) {
                XRecyclerView.this.mWrapAdapter.notifyDataSetChanged();
            }
            if (XRecyclerView.this.mWrapAdapter != null && XRecyclerView.this.mEmptyView != null) {
                int emptyCount = 1 + XRecyclerView.this.mWrapAdapter.getHeadersCount();
                if (XRecyclerView.this.loadingMoreEnabled) {
                    ++emptyCount;
                }
                if (XRecyclerView.this.mWrapAdapter.getItemCount() == emptyCount) {
                    XRecyclerView.this.mEmptyView.setVisibility(0);
                    XRecyclerView.this.setVisibility(8);
                } else {
                    XRecyclerView.this.mEmptyView.setVisibility(8);
                    XRecyclerView.this.setVisibility(0);
                }
            }
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            XRecyclerView.this.mWrapAdapter.notifyItemRangeInserted(positionStart, itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            XRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(positionStart, itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            XRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(positionStart, itemCount, payload);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            XRecyclerView.this.mWrapAdapter.notifyItemRangeRemoved(positionStart, itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            XRecyclerView.this.mWrapAdapter.notifyItemMoved(fromPosition, toPosition);
        }
    }
}

