/*
 * Decompiled with CFR 0.152.
 */
package com.jcodecraeer.xrecyclerview.progressindicator.indicator;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.LinearInterpolator;
import com.jcodecraeer.xrecyclerview.progressindicator.indicator.BaseIndicatorController;
import java.util.ArrayList;
import java.util.List;

public class PacmanIndicator
extends BaseIndicatorController {
    private float translateX;
    private int alpha;
    private float degrees1;
    private float degrees2;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        this.drawPacman(canvas, paint);
        this.drawCircle(canvas, paint);
    }

    private void drawPacman(Canvas canvas, Paint paint) {
        float x = this.getWidth() / 2;
        float y = this.getHeight() / 2;
        canvas.save();
        canvas.translate(x, y);
        canvas.rotate(this.degrees1);
        paint.setAlpha(255);
        RectF rectF1 = new RectF(-x / 1.7f, -y / 1.7f, x / 1.7f, y / 1.7f);
        canvas.drawArc(rectF1, 0.0f, 270.0f, true, paint);
        canvas.restore();
        canvas.save();
        canvas.translate(x, y);
        canvas.rotate(this.degrees2);
        paint.setAlpha(255);
        RectF rectF2 = new RectF(-x / 1.7f, -y / 1.7f, x / 1.7f, y / 1.7f);
        canvas.drawArc(rectF2, 90.0f, 270.0f, true, paint);
        canvas.restore();
    }

    private void drawCircle(Canvas canvas, Paint paint) {
        float radius = this.getWidth() / 11;
        paint.setAlpha(this.alpha);
        canvas.drawCircle(this.translateX, (float)(this.getHeight() / 2), radius, paint);
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        float startT = this.getWidth() / 11;
        ValueAnimator translationAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getWidth() - startT, this.getWidth() / 2});
        translationAnim.setDuration(650L);
        translationAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        translationAnim.setRepeatCount(-1);
        translationAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PacmanIndicator.this.translateX = ((Float)animation.getAnimatedValue()).floatValue();
                PacmanIndicator.this.postInvalidate();
            }
        });
        translationAnim.start();
        ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 122});
        alphaAnim.setDuration(650L);
        alphaAnim.setRepeatCount(-1);
        alphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PacmanIndicator.this.alpha = (Integer)animation.getAnimatedValue();
                PacmanIndicator.this.postInvalidate();
            }
        });
        alphaAnim.start();
        ValueAnimator rotateAnim1 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 45.0f, 0.0f});
        rotateAnim1.setDuration(650L);
        rotateAnim1.setRepeatCount(-1);
        rotateAnim1.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PacmanIndicator.this.degrees1 = ((Float)animation.getAnimatedValue()).floatValue();
                PacmanIndicator.this.postInvalidate();
            }
        });
        rotateAnim1.start();
        ValueAnimator rotateAnim2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, -45.0f, 0.0f});
        rotateAnim2.setDuration(650L);
        rotateAnim2.setRepeatCount(-1);
        rotateAnim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PacmanIndicator.this.degrees2 = ((Float)animation.getAnimatedValue()).floatValue();
                PacmanIndicator.this.postInvalidate();
            }
        });
        rotateAnim2.start();
        animators.add((Animator)translationAnim);
        animators.add((Animator)alphaAnim);
        animators.add((Animator)rotateAnim1);
        animators.add((Animator)rotateAnim2);
        return animators;
    }
}

