/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.springboot.starter.cache;

import com.jeesuite.cache.local.EhCacheLevel1CacheProvider;
import com.jeesuite.cache.local.GuavaLevel1CacheProvider;
import com.jeesuite.cache.local.Level1CacheProvider;
import com.jeesuite.cache.local.Level1CacheSupport;
import com.jeesuite.cache.redis.JedisProviderFactoryBean;
import com.jeesuite.springboot.starter.cache.CacheProperties;
import com.jeesuite.springboot.starter.cache.Level1CacheProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@EnableConfigurationProperties(value={CacheProperties.class, Level1CacheProperties.class})
@ConditionalOnClass(value={JedisProviderFactoryBean.class})
@ConditionalOnProperty(name={"jeesuite.cache.mode"})
public class DelegateCacheConfiguration {
    @Autowired
    private CacheProperties cacheProperties;
    @Autowired
    private Level1CacheProperties level1CacheProperties;

    @Bean
    public JedisProviderFactoryBean jedisProviderFactory(@Qualifier(value="jedisPoolConfig") JedisPoolConfig config) {
        JedisProviderFactoryBean bean = new JedisProviderFactoryBean();
        bean.setDatabase(this.cacheProperties.getDatabase());
        bean.setJedisPoolConfig(config);
        bean.setMode(this.cacheProperties.getMode());
        bean.setServers(this.cacheProperties.getServers());
        bean.setPassword(this.cacheProperties.getPassword());
        bean.setMasterName(this.cacheProperties.getMasterName());
        bean.setGroup(this.cacheProperties.getGroupName());
        return bean;
    }

    @Bean(name={"jedisPoolConfig"})
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(this.cacheProperties.getMaxPoolSize());
        config.setMaxIdle(this.cacheProperties.getMaxPoolIdle());
        config.setMinIdle(this.cacheProperties.getMinPoolIdle());
        config.setMaxWaitMillis(this.cacheProperties.getMaxPoolWaitMillis());
        return config;
    }

    @Bean
    public Level1CacheSupport level1CacheSupport() {
        Level1CacheSupport support = new Level1CacheSupport();
        if (this.level1CacheProperties != null) {
            support.setBcastScope(this.level1CacheProperties.getBcastScope());
            support.setBcastServer(this.level1CacheProperties.getBcastServer());
            support.setCacheNames(this.level1CacheProperties.getCacheNames());
            support.setDistributedMode(this.level1CacheProperties.isDistributedMode());
            support.setPassword(this.level1CacheProperties.getPassword());
            if ("guavacache".equals(this.level1CacheProperties.getCacheProvider())) {
                GuavaLevel1CacheProvider cacheProvider = new GuavaLevel1CacheProvider();
                cacheProvider.setMaxSize(this.level1CacheProperties.getMaxCacheSize());
                cacheProvider.setTimeToLiveSeconds(this.level1CacheProperties.getTimeToLiveSeconds());
                support.setCacheProvider((Level1CacheProvider)cacheProvider);
            } else {
                EhCacheLevel1CacheProvider cacheProvider = new EhCacheLevel1CacheProvider();
                support.setCacheProvider((Level1CacheProvider)cacheProvider);
            }
        }
        return support;
    }
}

