/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.springboot.starter.kafka;

import com.jeesuite.kafka.consumer.hanlder.OffsetLogHanlder;
import com.jeesuite.kafka.consumer.hanlder.RetryErrorMessageHandler;
import com.jeesuite.kafka.spring.TopicConsumerSpringProvider;
import com.jeesuite.springboot.starter.kafka.KafkaConsumerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KafkaConsumerProperties.class})
@ConditionalOnClass(value={TopicConsumerSpringProvider.class})
@ConditionalOnProperty(name={"kafka.bootstrap.servers"})
public class DelegateKafkaConsumerConfiguration {
    @Autowired
    private KafkaConsumerProperties properties;
    @Autowired(required=false)
    private OffsetLogHanlder offsetLogHanlder;
    @Autowired(required=false)
    private RetryErrorMessageHandler retryErrorMessageHandler;

    @Bean
    public TopicConsumerSpringProvider comsumerProvider() {
        TopicConsumerSpringProvider bean = new TopicConsumerSpringProvider();
        bean.setConfigs(this.properties.getConfigs());
        bean.setIndependent(this.properties.isIndependent());
        bean.setProcessThreads(this.properties.getProcessThreads());
        bean.setUseNewAPI(this.properties.isUseNewAPI());
        bean.setScanPackages(this.properties.getScanPackages());
        bean.setOffsetLogHanlder(this.offsetLogHanlder);
        bean.setRetryErrorMessageHandler(this.retryErrorMessageHandler);
        return bean;
    }
}

