/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.springboot.starter.kafka;

import com.jeesuite.kafka.spring.TopicProducerSpringProvider;
import com.jeesuite.springboot.starter.kafka.KafkaProducerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KafkaProducerProperties.class})
@ConditionalOnClass(value={TopicProducerSpringProvider.class})
@ConditionalOnProperty(name={"kafka.bootstrap.servers"})
public class DelegateKafkaProducerConfiguration {
    @Autowired
    private KafkaProducerProperties producerProperties;

    @Bean
    public TopicProducerSpringProvider producerProvider() {
        TopicProducerSpringProvider bean = new TopicProducerSpringProvider();
        bean.setConfigs(this.producerProperties.getConfigs());
        bean.setDefaultAsynSend(this.producerProperties.isDefaultAsynSend());
        bean.setDelayRetries(this.producerProperties.getDelayRetries());
        bean.setProducerGroup(this.producerProperties.getProducerGroup());
        bean.setMonitorEnabled(this.producerProperties.isMonitorEnabled());
        bean.setConsumerAckEnabled(this.producerProperties.isConsumerAckEnabled());
        return bean;
    }
}

