/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.springboot.starter.kafka;

import java.util.Map;
import java.util.Properties;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@ConfigurationProperties(prefix="jeesuite.kafka.consumer")
public class KafkaConsumerProperties
implements EnvironmentAware {
    private boolean independent;
    private boolean useNewAPI;
    private int processThreads = 100;
    private String scanPackages;
    private Properties configs = new Properties();

    public boolean isIndependent() {
        return this.independent;
    }

    public void setIndependent(boolean independent) {
        this.independent = independent;
    }

    public boolean isUseNewAPI() {
        return this.useNewAPI;
    }

    public void setUseNewAPI(boolean useNewAPI) {
        this.useNewAPI = useNewAPI;
    }

    public int getProcessThreads() {
        return this.processThreads;
    }

    public void setProcessThreads(int processThreads) {
        this.processThreads = processThreads;
    }

    public String getScanPackages() {
        return this.scanPackages;
    }

    public void setScanPackages(String scanPackages) {
        this.scanPackages = scanPackages;
    }

    public Properties getConfigs() {
        return this.configs;
    }

    public void setConfigs(Properties configs) {
        this.configs = configs;
    }

    public void setEnvironment(Environment environment) {
        RelaxedPropertyResolver resolver;
        Map subProperties;
        String kafkaServers = environment.getProperty("kafka.bootstrap.servers");
        String zkServers = environment.getProperty("kafka.zkServers");
        this.configs.put("bootstrap.servers", kafkaServers);
        if (!this.useNewAPI && zkServers != null) {
            this.configs.put("zookeeper.connect", zkServers);
        }
        if ((subProperties = (resolver = new RelaxedPropertyResolver((PropertyResolver)environment, "kafka.consumer.")).getSubProperties("")) != null && !subProperties.isEmpty()) {
            this.configs.putAll((Map<?, ?>)subProperties);
        }
    }
}

