/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.springboot.starter.kafka;

import java.util.Map;
import java.util.Properties;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@ConfigurationProperties(prefix="jeesuite.kafka.producer")
public class KafkaProducerProperties
implements EnvironmentAware {
    private boolean defaultAsynSend;
    private String producerGroup;
    private boolean monitorEnabled;
    private boolean consumerAckEnabled;
    private int delayRetries = 0;
    private Properties configs = new Properties();

    public boolean isDefaultAsynSend() {
        return this.defaultAsynSend;
    }

    public void setDefaultAsynSend(boolean defaultAsynSend) {
        this.defaultAsynSend = defaultAsynSend;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public boolean isMonitorEnabled() {
        return this.monitorEnabled;
    }

    public void setMonitorEnabled(boolean monitorEnabled) {
        this.monitorEnabled = monitorEnabled;
    }

    public int getDelayRetries() {
        return this.delayRetries;
    }

    public void setDelayRetries(int delayRetries) {
        this.delayRetries = delayRetries;
    }

    public Properties getConfigs() {
        return this.configs;
    }

    public void setConfigs(Properties configs) {
        this.configs = configs;
    }

    public boolean isConsumerAckEnabled() {
        return this.consumerAckEnabled;
    }

    public void setConsumerAckEnabled(boolean consumerAckEnabled) {
        this.consumerAckEnabled = consumerAckEnabled;
    }

    public void setEnvironment(Environment environment) {
        String kafkaServers = environment.getProperty("kafka.bootstrap.servers");
        this.configs.put("bootstrap.servers", kafkaServers);
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment, "kafka.producer.");
        Map subProperties = resolver.getSubProperties("");
        if (subProperties != null && !subProperties.isEmpty()) {
            this.configs.putAll((Map<?, ?>)subProperties);
        }
    }
}

