/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.springboot.starter.mybatis;

import com.jeesuite.mybatis.datasource.MutiRouteDataSource;
import com.jeesuite.mybatis.parser.EntityInfo;
import com.jeesuite.mybatis.parser.MybatisMapperParser;
import com.jeesuite.mybatis.plugin.JeesuiteMybatisInterceptor;
import com.jeesuite.springboot.starter.mybatis.MybatisPluginProperties;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import tk.mybatis.mapper.entity.Config;
import tk.mybatis.mapper.mapperhelper.MapperHelper;

@Configuration
@EnableConfigurationProperties(value={MybatisPluginProperties.class})
@ConditionalOnClass(value={MutiRouteDataSource.class})
@AutoConfigureAfter(value={MybatisAutoConfiguration.class})
public class JeesuiteMybatisConfiguration
implements InitializingBean {
    @Autowired
    private SqlSessionFactory sqlSessionFactory;
    @Autowired
    private MybatisPluginProperties properties;
    @Value(value="${mybatis.mapper-locations}")
    private String mapperLocations;

    public void afterPropertiesSet() throws Exception {
        String interceptorHandlers = null;
        if (this.properties.isCacheEnabled()) {
            interceptorHandlers = "cache";
        }
        if (this.properties.isRwRouteEnabled()) {
            String string = interceptorHandlers = interceptorHandlers == null ? "rwRoute" : interceptorHandlers + ",rwRoute";
        }
        if (this.properties.isDbShardEnabled()) {
            String string = interceptorHandlers = interceptorHandlers == null ? "dbShard" : interceptorHandlers + ",dbShard";
        }
        if (this.properties.isPaginationEnabled()) {
            String string = interceptorHandlers = interceptorHandlers == null ? "page" : interceptorHandlers + ",page";
        }
        if (interceptorHandlers != null) {
            JeesuiteMybatisInterceptor interceptor = new JeesuiteMybatisInterceptor();
            interceptor.setMapperLocations(this.mapperLocations);
            interceptor.setInterceptorHandlers(interceptorHandlers);
            this.sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)interceptor);
            Properties p = new Properties();
            p.setProperty("crudDriver", this.properties.getCrudDriver());
            p.setProperty("dbType", this.properties.getDbType());
            p.setProperty("cache.nullValue", String.valueOf(this.properties.isNullValueCache()));
            p.setProperty("cache.expire.seconds", String.valueOf(this.properties.getCacheExpireSeconds()));
            p.setProperty("cache.dynamic.expire", String.valueOf(this.properties.isDynamicExpire()));
            interceptor.setProperties(p);
            interceptor.afterPropertiesSet();
        } else {
            MybatisMapperParser.setMapperLocations((String)this.mapperLocations);
        }
        MapperHelper mapperHelper = new MapperHelper();
        Config config = new Config();
        config.setNotEmpty(false);
        mapperHelper.setConfig(config);
        List entityInfos = MybatisMapperParser.getEntityInfos();
        for (EntityInfo entityInfo : entityInfos) {
            mapperHelper.registerMapper(entityInfo.getMapperClass());
        }
        mapperHelper.processConfiguration(this.sqlSessionFactory.getConfiguration());
    }
}

