/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.springboot.starter.scheduler;

import com.jeesuite.scheduler.JobRegistry;
import com.jeesuite.scheduler.SchedulerFactoryBeanWrapper;
import com.jeesuite.scheduler.registry.NullJobRegistry;
import com.jeesuite.scheduler.registry.ZkJobRegistry;
import com.jeesuite.springboot.starter.scheduler.SchedulerProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={SchedulerProperties.class})
@ConditionalOnClass(value={SchedulerFactoryBeanWrapper.class})
@ConditionalOnProperty(name={"jeesuite.task.groupName"})
public class DelegateScheConfiguration {
    @Autowired
    private SchedulerProperties cacheProperties;

    @Bean
    public JobRegistry jobRegistry() {
        if (StringUtils.isNotBlank((CharSequence)this.cacheProperties.getRegistryServers())) {
            ZkJobRegistry registry = new ZkJobRegistry();
            registry.setZkServers(this.cacheProperties.getRegistryServers());
            return registry;
        }
        return new NullJobRegistry();
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public SchedulerFactoryBeanWrapper schedulerFactoryBean(JobRegistry jobRegistry) {
        SchedulerFactoryBeanWrapper bean = new SchedulerFactoryBeanWrapper();
        bean.setGroupName(this.cacheProperties.getGroupName());
        bean.setThreadPoolSize(this.cacheProperties.getThreadPoolSize());
        bean.setRegistry(jobRegistry);
        bean.setScanPackages(this.cacheProperties.getScanPackages());
        return bean;
    }
}

