/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.bytecode.structure.Attribute;

import com.jfirer.baseutil.bytecode.structure.Attribute.AnnotationDefaultAttriInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.CodeAttriInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.LocalVariableTableAttriInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.RuntimeVisibleAnnotationsAttriInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.RuntimeVisibleParameterAnnotationsAttrInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.UnknowAttrInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.ConstantInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.Utf8Info;
import com.jfirer.baseutil.bytecode.util.BinaryData;

public abstract class AttributeInfo {
    protected String name;
    protected int length;

    public AttributeInfo(String name, int length) {
        this.name = name;
        this.length = length;
    }

    public static AttributeInfo parse(BinaryData binaryData, ConstantInfo[] constantInfos) {
        int nameIndex = binaryData.readShort();
        int length = binaryData.readInt();
        String name = ((Utf8Info)constantInfos[nameIndex - 1]).getValue();
        AttributeInfo info = "RuntimeVisibleAnnotations".equals(name) ? new RuntimeVisibleAnnotationsAttriInfo(name, length) : ("RuntimeVisibleParameterAnnotations".equals(name) ? new RuntimeVisibleParameterAnnotationsAttrInfo(name, length) : ("AnnotationDefault".equals(name) ? new AnnotationDefaultAttriInfo(name, length) : ("Code".equals(name) ? new CodeAttriInfo(name, length) : ("LocalVariableTable".equals(name) ? new LocalVariableTableAttriInfo(name, length) : new UnknowAttrInfo(name, length)))));
        ((AttributeInfo)info).resolve(binaryData, constantInfos);
        return info;
    }

    public int getLength() {
        return this.length;
    }

    protected abstract void resolve(BinaryData var1, ConstantInfo[] var2);

    protected void ignoreParse(BinaryData binaryData) {
        binaryData.addIndex(this.length);
    }

    public String toString() {
        return "AttributeInfo{name='" + this.name + '\'' + ", length=" + this.length + '}';
    }
}

