/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.bytecode.structure.Attribute;

import com.jfirer.baseutil.bytecode.structure.Attribute.AttributeInfo;
import com.jfirer.baseutil.bytecode.structure.ExceptionHandler;
import com.jfirer.baseutil.bytecode.structure.constantinfo.ConstantInfo;
import com.jfirer.baseutil.bytecode.util.BinaryData;
import java.util.Arrays;

public class CodeAttriInfo
extends AttributeInfo {
    private int max_stack;
    private int max_locals;
    private int code_length;
    private ExceptionHandler[] exceptionHandlers;
    private AttributeInfo[] attributeInfos;

    public CodeAttriInfo(String name, int length) {
        super(name, length);
    }

    @Override
    protected void resolve(BinaryData binaryData, ConstantInfo[] constantInfos) {
        this.max_stack = binaryData.readShort();
        this.max_locals = binaryData.readShort();
        this.code_length = binaryData.readInt();
        binaryData.addIndex(this.code_length);
        int exception_table_length = binaryData.readShort();
        binaryData.addIndex(exception_table_length * 8);
        int attributes_count = binaryData.readShort();
        this.attributeInfos = new AttributeInfo[attributes_count];
        for (int i = 0; i < this.attributeInfos.length; ++i) {
            this.attributeInfos[i] = CodeAttriInfo.parse(binaryData, constantInfos);
        }
    }

    public AttributeInfo[] getAttributeInfos() {
        return this.attributeInfos;
    }

    @Override
    public String toString() {
        return "CodeAttriInfo{max_stack=" + this.max_stack + ", max_locals=" + this.max_locals + ", code_length=" + this.code_length + ", exceptionHandlers=" + Arrays.toString(this.exceptionHandlers) + ", attributeInfos=" + Arrays.toString(this.attributeInfos) + '}';
    }
}

