/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.bytecode.support;

import com.jfirer.baseutil.bytecode.annotation.AnnotationMetadata;
import com.jfirer.baseutil.bytecode.support.AnnotationContext;
import java.lang.annotation.Annotation;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultAnnotationContext
implements AnnotationContext {
    private final List<AnnotationMetadata> metadataList;
    private Map<Class<?>, List<AnnotationMetadata>> metadataStore;
    private Map<Class<?>, List<Annotation>> annotationStore;

    public DefaultAnnotationContext(List<AnnotationMetadata> metadataList) {
        this.metadataList = metadataList;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> ckass) {
        String resourceName = ckass.getName().replace('.', '/');
        for (AnnotationMetadata annotationMetadata : this.metadataList) {
            if (this.find(annotationMetadata, resourceName) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public <E extends Annotation> E getAnnotation(Class<E> ckass) {
        return (E)this.getAnnotationMetadata(ckass).annotation();
    }

    private AnnotationMetadata find(AnnotationMetadata metadata, String resourceName) {
        if (metadata.isAnnotation(resourceName)) {
            return metadata;
        }
        for (AnnotationMetadata presentAnnotation : metadata.getPresentAnnotations()) {
            AnnotationMetadata result = this.find(presentAnnotation, resourceName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void findAll(AnnotationMetadata metadata, String resourceName, List<AnnotationMetadata> list) {
        if (metadata.isAnnotation(resourceName)) {
            list.add(metadata);
        }
        for (AnnotationMetadata presentAnnotation : metadata.getPresentAnnotations()) {
            this.findAll(presentAnnotation, resourceName, list);
        }
    }

    @Override
    public <E extends Annotation> List<E> getAnnotations(Class<E> ckass) {
        if (this.getAnnotationStore().containsKey(ckass)) {
            return this.getAnnotationStore().get(ckass);
        }
        LinkedList<Annotation> list = new LinkedList<Annotation>();
        for (AnnotationMetadata each : this.getAnnotationMetadatas(ckass)) {
            list.add(each.annotation());
        }
        this.getAnnotationStore().put(ckass, list);
        return list;
    }

    private Map<Class<?>, List<Annotation>> getAnnotationStore() {
        if (this.annotationStore != null) {
            return this.annotationStore;
        }
        this.annotationStore = new IdentityHashMap();
        return this.annotationStore;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata(Class<? extends Annotation> ckass) {
        String resourceName = ckass.getName().replace('.', '/');
        for (AnnotationMetadata each : this.metadataList) {
            AnnotationMetadata metadata = this.find(each, resourceName);
            if (metadata == null) continue;
            return metadata;
        }
        return null;
    }

    @Override
    public List<AnnotationMetadata> getAnnotationMetadatas(Class<? extends Annotation> ckass) {
        if (this.getMetadataStore().containsKey(ckass)) {
            return this.getMetadataStore().get(ckass);
        }
        String resourceName = ckass.getName().replace('.', '/');
        LinkedList<AnnotationMetadata> result = new LinkedList<AnnotationMetadata>();
        for (AnnotationMetadata each : this.metadataList) {
            this.findAll(each, resourceName, result);
        }
        this.getMetadataStore().put(ckass, result);
        return result;
    }

    private Map<Class<?>, List<AnnotationMetadata>> getMetadataStore() {
        if (this.metadataStore != null) {
            return this.metadataStore;
        }
        this.metadataStore = new IdentityHashMap();
        return this.metadataStore;
    }
}

