/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.uniqueid;

import com.jfirer.baseutil.uniqueid.Uid;
import java.lang.management.ManagementFactory;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Calendar;

public class WinterId
implements Uid {
    private static final char[] pid = (ManagementFactory.getRuntimeMXBean().getName().split("@")[0] + "_").toCharArray();
    private static volatile WinterId INSTANCE;
    private Sequencer sequencer = new Sequencer();

    private WinterId() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final WinterId instance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<WinterId> clazz = WinterId.class;
        synchronized (WinterId.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = new WinterId();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void main(String[] args) throws SocketException, UnknownHostException {
        WinterId id = WinterId.instance();
        String[] array = new String[1000];
        for (int i = 0; i < 1000; ++i) {
            array[i] = id.generate();
        }
        for (String each : array) {
            System.out.println(each);
        }
    }

    @Override
    public byte[] generateBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String generate() {
        return this.sequencer.next();
    }

    @Override
    public long generateLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String generateDigits() {
        return this.generate();
    }

    class Sequencer {
        final StringBuilder cache = new StringBuilder();
        int sequence;
        long lastTime;
        int pidLength;
        Calendar now = Calendar.getInstance();

        public Sequencer() {
            this.cache.append(pid);
            this.pidLength = pid.length;
        }

        synchronized String next() {
            long time = System.currentTimeMillis();
            if (time > this.lastTime) {
                this.sequence = 0;
                this.lastTime = time;
            } else {
                ++this.sequence;
            }
            this.now.setTimeInMillis(time);
            this.format(this.cache, this.now, this.sequence);
            String result = this.cache.toString();
            this.cache.setLength(this.pidLength);
            return result;
        }

        void format(StringBuilder cache, Calendar now, int sequence) {
            int year = now.get(1);
            cache.append(year);
            int month = now.get(2) + 1;
            if (month >= 10) {
                cache.append(month);
            } else {
                cache.append('0').append(month);
            }
            int dayInMonth = now.get(5);
            if (dayInMonth >= 10) {
                cache.append(dayInMonth);
            } else {
                cache.append(0).append(dayInMonth);
            }
            int hour = now.get(11);
            if (hour >= 10) {
                cache.append(hour);
            } else {
                cache.append('0').append(hour);
            }
            int minute = now.get(12);
            if (minute >= 10) {
                cache.append(minute);
            } else {
                cache.append('0').append(minute);
            }
            int seconds = now.get(13);
            if (seconds >= 10) {
                cache.append(seconds);
            } else {
                cache.append('0').append(seconds);
            }
            int millSeconds = now.get(14);
            if (millSeconds >= 100) {
                cache.append(millSeconds);
            } else if (millSeconds >= 10) {
                cache.append(0).append(millSeconds);
            } else {
                cache.append(0).append(0).append(millSeconds);
            }
            cache.append('_').append(sequence);
        }
    }
}

