/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util;

import com.flyfox.util.NumberUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Config {
    private static final URL classPathUrl = Config.class.getResource("/");
    private static final String classPath = new File(classPathUrl.getFile()).getPath();
    private static String configPath = "/conf/";
    private static final Map<String, String> configMap = new HashMap<String, String>();

    static {
        Config.setConfigMap();
    }

    public static void test() {
        for (String key : configMap.keySet()) {
            System.out.println(String.valueOf(key) + "=" + configMap.get(key));
        }
    }

    public static String getStr(String key) {
        if (configMap.size() < 0) {
            return null;
        }
        return configMap.get(key);
    }

    public static int getToInt(String key) {
        String val = Config.getStr(key);
        return NumberUtils.parseInt(val);
    }

    public static long getToLong(String key) {
        String val = Config.getStr(key);
        return NumberUtils.parseLong(val);
    }

    public static double getToDbl(String key) {
        String val = Config.getStr(key);
        return NumberUtils.parseDbl(val);
    }

    public static boolean getToBoolean(String key) {
        String val = Config.getStr(key);
        try {
            return Boolean.valueOf(val);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void setConfigMap() {
        String filePath = String.valueOf(classPath) + configPath;
        List<String> list = Config.findFiles(filePath);
        for (String configName : list) {
            Properties props = Config.getProperties(String.valueOf(filePath) + configName);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = String.valueOf(entry.getKey());
                String value = String.valueOf(entry.getValue());
                if (!configMap.containsKey(key)) {
                    configMap.put(key, value);
                    continue;
                }
                System.err.println("CONFIG EEOR:key(" + key + ") is exist;");
            }
        }
    }

    private static Properties getProperties(String fileName) {
        Properties props = new Properties();
        try {
            FileInputStream propFile = new FileInputStream(fileName);
            props.load(propFile);
        }
        catch (IOException e) {
            System.err.println("file read fail:" + fileName);
            e.printStackTrace();
        }
        return props;
    }

    private static List<String> findFiles(String baseDirName) {
        ArrayList<String> configFiles = new ArrayList<String>();
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.err.println("search error\uff1a" + baseDirName + "is not a dir\uff01");
        } else {
            String[] filelist;
            String[] stringArray = filelist = baseDir.list();
            int n = filelist.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (fileName.endsWith("properties")) {
                    configFiles.add(fileName);
                }
                ++n2;
            }
        }
        return configFiles;
    }
}

