/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util;

import com.flyfox.util.EPNDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DateUtils {
    public static final String DEFAULT_REGEX = "yyyy-MM-dd";
    public static final String DEFAULT_REGEX_YYYYMMDD = "yyyyMMdd";
    public static final String DEFAULT_REGEX_YYYY_MM_DD_HH_MIN_SS = "yyyy-MM-dd HH:mm:ss";
    private static final EPNDateFormat DEFAULT_FORMAT = new EPNDateFormat("yyyy-MM-dd");
    private static final EPNDateFormat DEFAULT_FORMAT_YYYY_MM_DD_HH_MIN_SS = new EPNDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final EPNDateFormat DEFAULT_FORMAT_YYYYMMDD = new EPNDateFormat("yyyyMMdd");
    private static Map<String, EPNDateFormat> formatMap = new HashMap<String, EPNDateFormat>();

    static {
        formatMap.put(DEFAULT_REGEX, DEFAULT_FORMAT);
        formatMap.put(DEFAULT_REGEX_YYYY_MM_DD_HH_MIN_SS, DEFAULT_FORMAT_YYYY_MM_DD_HH_MIN_SS);
        formatMap.put(DEFAULT_REGEX_YYYYMMDD, DEFAULT_FORMAT_YYYYMMDD);
    }

    private DateUtils() {
    }

    public static String format(Date date) {
        return DEFAULT_FORMAT.format(date);
    }

    public static String format(Date date, String regex) {
        return DateUtils.getDateFormat(regex).format(date);
    }

    private static EPNDateFormat getDateFormat(String regex) {
        EPNDateFormat fmt = formatMap.get(regex);
        if (fmt == null) {
            fmt = new EPNDateFormat(regex);
            formatMap.put(regex, fmt);
        }
        return fmt;
    }

    public static Date parseByAll(String time) {
        Date stamp = null;
        if (time == null || "".equals(time)) {
            return null;
        }
        Pattern p3 = Pattern.compile("\\b\\d{2}[.-]\\d{1,2}([.-]\\d{1,2}){0,1}\\b");
        if (p3.matcher(time).matches()) {
            time = String.valueOf(time.charAt(0) == '1' || time.charAt(0) == '0' ? "20" : "19") + time;
        }
        if ((stamp = DateUtils.parse(time, "yyyy-MM-ddHH:mm:ss")) == null) {
            stamp = DateUtils.parse(time, DEFAULT_REGEX);
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyy.MM.dd");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyy-MM");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyy.MM");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, DEFAULT_REGEX);
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yy-MM-dd");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyy.MM.dd");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyy-MM.dd");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyy.MM-dd");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, DEFAULT_REGEX_YYYYMMDD);
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyy\u5e74MM\u6708dd\u65e5");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyyMM");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyy\u5e74MM\u6708");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyy");
        }
        if (stamp == null) {
            stamp = DateUtils.parse(time, "yyyy\u5e74");
        }
        return stamp;
    }

    public static Date parse(String source) {
        try {
            return DEFAULT_FORMAT.parse(source);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parse(String source, String regex) {
        try {
            EPNDateFormat fmt = DateUtils.getDateFormat(regex);
            return fmt.parse(source);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getNowDate() {
        return new Date(System.currentTimeMillis());
    }

    public static String getNow() {
        return DateUtils.getNow(DEFAULT_REGEX);
    }

    public static String getNow(String regex) {
        return DateUtils.format(DateUtils.getNowDate(), regex);
    }
}

