/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static byte[] read(String path) throws IOException {
        int base_size = 1024;
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        int len = 0;
        byte[] dataByte = new byte[base_size];
        ByteArrayOutputStream out = new ByteArrayOutputStream(base_size);
        while ((len = fis.read(dataByte)) != -1) {
            out.write(dataByte, 0, len);
        }
        byte[] content = out.toByteArray();
        fis.close();
        out.close();
        if (content.length == 0) {
            return null;
        }
        return content;
    }

    public static void write(String path, byte[] data) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(data);
        fos.flush();
        fos.close();
    }

    public static List<String> findFiles(String baseDirName) {
        ArrayList<String> files = new ArrayList<String>();
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.err.println("search error\uff1a" + baseDirName + "is not a dir\uff01");
        } else {
            String[] filelist;
            String[] stringArray = filelist = baseDir.list();
            int n = filelist.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                files.add(fileName);
                ++n2;
            }
        }
        return files;
    }

    public static List<String> findFileNames(String baseDirName, FileFilter fileFilter) {
        ArrayList<String> files = new ArrayList<String>();
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.err.println("search error\uff1a" + baseDirName + "is not a dir\uff01");
        } else {
            File[] filelist;
            File[] fileArray = filelist = baseDir.listFiles(fileFilter);
            int n = filelist.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    files.add(file.getName());
                }
                ++n2;
            }
        }
        return files;
    }
}

