/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util;

import java.math.BigDecimal;

public class NumberUtils {
    private NumberUtils() {
    }

    public static int parseInt(Object obj) {
        int value = 0;
        if (obj != null) {
            try {
                value = Integer.parseInt(obj.toString());
            }
            catch (Exception e) {
                value = 0;
            }
        }
        return value;
    }

    public static BigDecimal parseBigDecimal(Object obj) {
        BigDecimal value = BigDecimal.ZERO;
        if (obj != null) {
            try {
                value = new BigDecimal(obj.toString());
            }
            catch (Exception e) {
                value = BigDecimal.ZERO;
            }
        }
        return value;
    }

    public static int parseInt(String str) {
        return NumberUtils.parseInt(str, 0);
    }

    public static int parseInt(String str, int defaultValue) {
        try {
            defaultValue = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static double parseDbl(String str) {
        return NumberUtils.parseDbl(str, 0.0);
    }

    public static double parseDbl(String str, double defaultValue) {
        try {
            defaultValue = Double.parseDouble(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static float parseFloat(String str) {
        return NumberUtils.parseFloat(str, 0.0f);
    }

    public static float parseFloat(String str, float b) {
        try {
            return Float.parseFloat(str);
        }
        catch (Exception e) {
            return b;
        }
    }

    public static long parseLong(String str) {
        return NumberUtils.parseLong(str, 0L);
    }

    public static long parseLong(String str, long defaultValue) {
        try {
            defaultValue = Long.parseLong(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

