/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    private static Method getDeclaredMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        Class<?> clazz = object.getClass();
        while (clazz != Object.class) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return method;
            }
            catch (Exception e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        Method method = ReflectionUtils.getDeclaredMethod(object, methodName, parameterTypes);
        if (method == null) {
            System.err.println(object.getClass() + "\u672a\u83b7\u53d6\u5230" + methodName + "\u65b9\u6cd5!");
            return null;
        }
        method.setAccessible(true);
        try {
            if (method != null) {
                return method.invoke(object, parameters);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Field getDeclaredField(Object object, String fieldName) {
        Field field = null;
        Class<?> clazz = object.getClass();
        while (clazz != Object.class) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        if (field == null) {
            System.err.println(object.getClass() + "\u672a\u83b7\u53d6\u5230" + fieldName + "\u5c5e\u6027!");
            return;
        }
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        if (field == null) {
            System.err.println(object.getClass() + "\u672a\u83b7\u53d6\u5230" + fieldName + "\u5c5e\u6027!");
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

