/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util.annotation;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassSearcher {
    static URL classPathUrl = ClassSearcher.class.getResource("/");
    static String lib = String.valueOf(new File(classPathUrl.getFile()).getParent()) + "/lib/";

    private static List<String> findFiles(String baseDirName, String targetFileName) {
        ArrayList<String> classFiles = new ArrayList<String>();
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.err.println("search error\uff1a" + baseDirName + "is not a dir\uff01");
        } else {
            String[] filelist = baseDir.list();
            int i = 0;
            while (i < filelist.length) {
                File readfile = new File(String.valueOf(baseDirName) + File.separator + filelist[i]);
                if (readfile.isDirectory()) {
                    classFiles.addAll(ClassSearcher.findFiles(String.valueOf(baseDirName) + File.separator + filelist[i], targetFileName));
                } else {
                    tempName = readfile.getName();
                    if (ClassSearcher.wildcardMatch(targetFileName, tempName)) {
                        String tem = readfile.getAbsoluteFile().toString().replaceAll("\\\\", "/");
                        String classname = tem.substring(tem.indexOf("/classes") + "/classes".length(), tem.indexOf(".class"));
                        if (classname.startsWith("/")) {
                            classname = classname.substring(classname.indexOf("/") + 1);
                        }
                        classname = ClassSearcher.className(classname, "/classes");
                        classFiles.add(classname);
                    }
                }
                ++i;
            }
        }
        return classFiles;
    }

    public static List<String> findjarFiles(String baseDirName, final List<String> includeJars) {
        ArrayList<String> classFiles = new ArrayList<String>();
        try {
            File baseDir = new File(baseDirName);
            if (!baseDir.exists() || !baseDir.isDirectory()) {
                System.out.println("####warn####file serach error\uff1a" + baseDirName + "is not a dir\uff01");
            } else {
                String[] filelist = baseDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return includeJars.contains(name);
                    }
                });
                int i = 0;
                while (i < filelist.length) {
                    JarFile localJarFile = new JarFile(new File(String.valueOf(baseDirName) + File.separator + filelist[i]));
                    Enumeration<JarEntry> entries = localJarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        String entryName = jarEntry.getName();
                        if (jarEntry.isDirectory() || !entryName.endsWith(".class")) continue;
                        String className = entryName.replaceAll("/", ".").substring(0, entryName.length() - 6);
                        classFiles.add(className);
                    }
                    localJarFile.close();
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classFiles;
    }

    public static <T> List<Class<? extends T>> findInClasspathAndJars(Class<T> clazz, List<String> includeJars) {
        List<String> classFileList = ClassSearcher.findFiles(classPathUrl.getFile(), "*.class");
        classFileList.addAll(ClassSearcher.findjarFiles(lib, includeJars));
        return ClassSearcher.extraction(clazz, classFileList);
    }

    private static <T> List<Class<? extends T>> extraction(Class<T> clazz, List<String> classFileList) {
        ArrayList<Class<T>> classList = new ArrayList<Class<T>>();
        for (String classFile : classFileList) {
            Class<?> classInFile = null;
            try {
                classInFile = Class.forName(classFile);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (!clazz.isAssignableFrom(classInFile) || clazz == classInFile) continue;
            classList.add(classInFile);
        }
        return classList;
    }

    private static String className(String classFile, String pre) {
        String objStr = classFile.replaceAll("\\\\", "/");
        return objStr.replaceAll("/", ".");
    }

    private static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        int patternIndex = 0;
        while (patternIndex < patternLength) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (ClassSearcher.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
            } else if (ch == '?') {
                if (++strIndex > strLength) {
                    return false;
                }
            } else {
                if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                    return false;
                }
                ++strIndex;
            }
            ++patternIndex;
        }
        return strIndex == strLength;
    }

    public static <T> List<Class<? extends T>> findInClasspath(Class<T> clazz) {
        List<String> classFileList = ClassSearcher.findFiles(classPathUrl.getFile(), "*.class");
        return ClassSearcher.extraction(clazz, classFileList);
    }
}

