/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util.cache;

import com.flyfox.util.cache.Cache;
import com.flyfox.util.cache.ICacheManager;
import com.flyfox.util.cache.impl.MemorySerializeCache;
import com.flyfox.util.serializable.SerializerManage;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CacheManager {
    private static ConcurrentHashMap<String, Cache> cacheManager = new ConcurrentHashMap();
    static ICacheManager _CreateCache = new ICacheManager(){

        @Override
        public Cache getCache() {
            return new MemorySerializeCache(SerializerManage.get("java"));
        }
    };

    protected CacheManager() {
    }

    public static void setCache(ICacheManager thisCache) {
        _CreateCache = thisCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache get(String name) {
        Cache cache = cacheManager.get(name);
        if (cache == null) {
            ConcurrentHashMap<String, Cache> concurrentHashMap = cacheManager;
            synchronized (concurrentHashMap) {
                cache = cacheManager.get(name);
                if (cache == null) {
                    cache = _CreateCache.getCache();
                    cache.name(name);
                    cacheManager.put(name, cache);
                }
            }
        }
        return cache;
    }

    public static int size() {
        return cacheManager.size();
    }

    public static Collection<Cache> values() {
        return cacheManager.values();
    }

    public static Set<String> keys() {
        return cacheManager.keySet();
    }
}

