/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util.cache.impl;

import com.flyfox.util.cache.Cache;
import com.flyfox.util.serializable.Serializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemorySerializeCache
implements Cache {
    protected Serializer serializer;
    protected String name;
    protected Map<String, byte[]> map = new ConcurrentHashMap<String, byte[]>();

    public MemorySerializeCache(Serializer serializer) {
        this.serializer = serializer;
    }

    public String name() {
        return this.name;
    }

    @Override
    public MemorySerializeCache name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MemorySerializeCache add(String key, Object value) {
        try {
            this.map.put(key, this.serializer.serialize(value));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public <T> T get(String key) {
        try {
            return this.serializer.deserialize(this.map.get(key));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Object remove(String key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public <T> List<T> list() {
        if (this.map.size() == 0) {
            return null;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (byte[] obj : this.map.values()) {
            list.add(obj);
        }
        return list;
    }
}

