/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util.extend;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlUtils {
    private static final String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
    private static final String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
    private static final String regEx_html = "<[^>]+>";

    public static String delHTMLTag(String htmlStr) {
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static String changeTag(String content) {
        return HtmlUtils.changeSpecialCode(content);
    }

    public static String changeSpecialCode(String content) {
        content = content.replaceAll("&", "&amp;");
        content = content.replaceAll("<", "&lt;");
        content = content.replaceAll(">", "&gt;");
        content = content.replaceAll("\"", "&quot;");
        content = content.replaceAll("'", "&#x27;");
        content = content.replaceAll("/", "&#x2f;");
        return content;
    }

    public static String delSpecialCode(String content) {
        content = content.replaceAll("&", "");
        content = content.replaceAll("<", "");
        content = content.replaceAll(">", "");
        content = content.replaceAll("\"", "");
        content = content.replaceAll("'", "");
        content = content.replaceAll("/", "");
        return content;
    }
}

