/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util.extend;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;

public class IdCheck {
    protected String[][] codeAndCity = new String[][]{{"11", "\u5317\u4eac"}, {"12", "\u5929\u6d25"}, {"13", "\u6cb3\u5317"}, {"14", "\u5c71\u897f"}, {"15", "\u5185\u8499\u53e4"}, {"21", "\u8fbd\u5b81"}, {"22", "\u5409\u6797"}, {"23", "\u9ed1\u9f99\u6c5f"}, {"31", "\u4e0a\u6d77"}, {"32", "\u6c5f\u82cf"}, {"33", "\u6d59\u6c5f"}, {"34", "\u5b89\u5fbd"}, {"35", "\u798f\u5efa"}, {"36", "\u6c5f\u897f"}, {"37", "\u5c71\u4e1c"}, {"41", "\u6cb3\u5357"}, {"42", "\u6e56\u5317"}, {"43", "\u6e56\u5357"}, {"44", "\u5e7f\u4e1c"}, {"45", "\u5e7f\u897f"}, {"46", "\u6d77\u5357"}, {"50", "\u91cd\u5e86"}, {"51", "\u56db\u5ddd"}, {"52", "\u8d35\u5dde"}, {"53", "\u4e91\u5357"}, {"54", "\u897f\u85cf"}, {"61", "\u9655\u897f"}, {"62", "\u7518\u8083"}, {"63", "\u9752\u6d77"}, {"64", "\u5b81\u590f"}, {"65", "\u65b0\u7586"}, {"71", "\u53f0\u6e7e"}, {"81", "\u9999\u6e2f"}, {"82", "\u6fb3\u95e8"}, {"91", "\u56fd\u5916"}};
    private String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private String[] verifyCode = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};

    public static boolean isValidatedAllIdcard(String idcard) {
        if (idcard.length() == 15) {
            idcard = IdCheck.convertIdcarBy15bit(idcard);
        }
        return IdCheck.isValidate18Idcard(idcard);
    }

    public static boolean isValidate18Idcard(String idcard) {
        if (idcard.length() != 18) {
            return false;
        }
        String idcard17 = idcard.substring(0, 17);
        String idcard18Code = idcard.substring(17, 18);
        char[] c = null;
        String checkCode = "";
        if (!IdCheck.isDigital(idcard17)) {
            return false;
        }
        c = idcard17.toCharArray();
        if (c != null) {
            int[] bit = new int[idcard17.length()];
            bit = IdCheck.converCharToInt(c);
            int sum17 = 0;
            sum17 = IdCheck.getPowerSum(bit);
            checkCode = IdCheck.getCheckCodeBySum(sum17);
            if (checkCode == null) {
                return false;
            }
            if (!idcard18Code.equalsIgnoreCase(checkCode)) {
                return false;
            }
        }
        return true;
    }

    public static String convertIdcarBy15bit(String idcard) {
        String idcard17 = null;
        if (idcard.length() != 15) {
            return null;
        }
        if (IdCheck.isDigital(idcard)) {
            String birthday = idcard.substring(6, 12);
            Date birthdate = null;
            try {
                birthdate = new SimpleDateFormat("yyMMdd").parse(birthday);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Calendar cday = Calendar.getInstance();
            cday.setTime(birthdate);
            String year = String.valueOf(cday.get(1));
            idcard17 = String.valueOf(idcard.substring(0, 6)) + year + idcard.substring(8);
            char[] c = idcard17.toCharArray();
            String checkCode = "";
            if (c != null) {
                int[] bit = new int[idcard17.length()];
                bit = IdCheck.converCharToInt(c);
                int sum17 = 0;
                sum17 = IdCheck.getPowerSum(bit);
                checkCode = IdCheck.getCheckCodeBySum(sum17);
                if (checkCode == null) {
                    return null;
                }
                idcard17 = String.valueOf(idcard17) + checkCode;
            }
        } else {
            return null;
        }
        return idcard17;
    }

    public boolean isIdcard(String idcard) {
        return idcard == null || "".equals(idcard) ? false : Pattern.matches("(^\\d{15}$)|(\\d{17}(?:\\d|x|X)$)", idcard);
    }

    public static boolean isDigital(String str) {
        return str == null || "".equals(str) ? false : str.matches("^[0-9]*$");
    }

    public static int getPowerSum(int[] bit) {
        int sum = 0;
        if (power.length != bit.length) {
            return sum;
        }
        int i = 0;
        while (i < bit.length) {
            int j = 0;
            while (j < power.length) {
                if (i == j) {
                    sum += bit[i] * power[j];
                }
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static String getCheckCodeBySum(int sum17) {
        String checkCode = null;
        switch (sum17 % 11) {
            case 10: {
                checkCode = "2";
                break;
            }
            case 9: {
                checkCode = "3";
                break;
            }
            case 8: {
                checkCode = "4";
                break;
            }
            case 7: {
                checkCode = "5";
                break;
            }
            case 6: {
                checkCode = "6";
                break;
            }
            case 5: {
                checkCode = "7";
                break;
            }
            case 4: {
                checkCode = "8";
                break;
            }
            case 3: {
                checkCode = "9";
                break;
            }
            case 2: {
                checkCode = "x";
                break;
            }
            case 1: {
                checkCode = "0";
                break;
            }
            case 0: {
                checkCode = "1";
            }
        }
        return checkCode;
    }

    public static int[] converCharToInt(char[] c) throws NumberFormatException {
        int[] a = new int[c.length];
        int k = 0;
        char[] cArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            char temp = cArray[n2];
            a[k++] = Integer.parseInt(String.valueOf(temp));
            ++n2;
        }
        return a;
    }
}

