/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util.extend.mp3;

import com.flyfox.util.extend.mp3.FrameInfo;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MusicInfo {
    private String path = "";
    private boolean isAnalysis = false;
    private final int HEADER_SIZE = 3;
    private byte[] header;
    private String HEAHER_START = "ID3";
    private byte version;
    private byte reVersion;
    private byte flag;
    private int SIZE_SIZE = 4;
    private byte[] size;
    private Map<String, FrameInfo> frameInfos = new HashMap<String, FrameInfo>();
    private int LABEL_SIZE = 10;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isAnalysis() {
        return this.isAnalysis;
    }

    public void setAnalysis(boolean isAnalysis) {
        this.isAnalysis = isAnalysis;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public byte getReVersion() {
        return this.reVersion;
    }

    public void setReVersion(byte reVersion) {
        this.reVersion = reVersion;
    }

    public byte getFlag() {
        return this.flag;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public byte[] getSize() {
        return this.size;
    }

    public void setSize(byte[] size) {
        this.size = size;
    }

    public Map<String, FrameInfo> getFrameInfos() {
        return this.frameInfos;
    }

    public int parseMusic() {
        return this.parseMusic("UTF-16");
    }

    public int parseMusic(String charset) {
        File file = new File(this.path);
        if (!file.exists()) {
            return 2;
        }
        if (!file.getName().endsWith(".mp3")) {
            return 1;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            this.header = new byte[3];
            raf.read(this.header, 0, 3);
            if (new String(this.header).equals(this.HEAHER_START)) {
                this.version = raf.readByte();
                System.out.println("version:" + this.version);
                this.reVersion = raf.readByte();
                System.out.println("reVersion:" + this.reVersion);
                this.flag = raf.readByte();
                System.out.println("flag:" + this.flag);
                this.size = new byte[this.SIZE_SIZE];
                raf.read(this.size);
                int i = 0;
                while (i < this.size.length) {
                    System.out.println("size[" + i + "]\uff1a0x" + this.parseDecimalToBinary(this.size[i]));
                    ++i;
                }
                byte[] label = new byte[this.LABEL_SIZE];
                raf.read(label);
                FrameInfo frameInfo = null;
                while ((frameInfo = this.decodeFrame(label)) != null) {
                    int frameContentSize = frameInfo.getFrameContentSize();
                    byte[] content = new byte[frameContentSize];
                    raf.skipBytes(1);
                    raf.read(content);
                    frameInfo.setContent(content);
                    this.frameInfos.put(frameInfo.getFrameId(), frameInfo);
                    raf.read(label);
                }
                raf.close();
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 3;
        }
    }

    public Map<String, byte[]> getImage() {
        if (this.frameInfos == null) {
            return null;
        }
        FrameInfo apicInfo = this.frameInfos.get("APIC");
        if (apicInfo == null) {
            return null;
        }
        byte[] apic = apicInfo.getContent();
        boolean isMIMEComplte = false;
        int i = 0;
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        while (i < apic.length) {
            if (!isMIMEComplte & apic[i] == 0) {
                byte[] mime = new String(apic, 0, i).getBytes();
                map.put("mime", mime);
                boolean bl = isMIMEComplte = !isMIMEComplte;
            }
            if (apic[i] == -1 && apic[i + 1] == -40) {
                byte[] data = new byte[apic.length - i];
                int j = 0;
                while (j < data.length) {
                    data[j] = apic[i + j];
                    ++j;
                }
                map.put("data", data);
                return map;
            }
            ++i;
        }
        return null;
    }

    public String getTitle(String charset) {
        if (this.frameInfos == null) {
            return null;
        }
        FrameInfo titleInfo = this.frameInfos.get("TIT2");
        if (titleInfo == null) {
            return null;
        }
        try {
            String title = new String(titleInfo.getContent(), charset);
            return title;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTitle() {
        return this.getTitle("UTF-16");
    }

    public String getPerformer(String charset) {
        if (this.frameInfos == null) {
            return null;
        }
        FrameInfo performerInfo = this.frameInfos.get("TPE1");
        if (performerInfo == null) {
            return null;
        }
        try {
            String performer = new String(performerInfo.getContent(), charset);
            return performer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPerformer() {
        return this.getPerformer("UTF-16");
    }

    public String getAlbum(String charset) {
        if (this.frameInfos == null) {
            return null;
        }
        FrameInfo albumInfo = this.frameInfos.get("TALB");
        if (albumInfo == null) {
            return null;
        }
        try {
            String album = new String(albumInfo.getContent(), charset);
            return album;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getAlbum() {
        return this.getAlbum("UTF-16");
    }

    private String parseDecimalToBinary(byte decimal) {
        byte temp = decimal;
        String tempStr = "";
        int j = 0;
        while (j < 8) {
            int x = temp >> j & 1;
            tempStr = String.valueOf(x) + tempStr;
            ++j;
        }
        return tempStr;
    }

    private FrameInfo decodeFrame(byte[] frameHead) {
        String frameId;
        block8: {
            if (frameHead.length != this.LABEL_SIZE) {
                return null;
            }
            try {
                frameId = new String(frameHead, 0, 4);
                Pattern pattern = Pattern.compile("[A-Z]{3}[A-Z0-9]{1}");
                Matcher matcher = pattern.matcher(frameId);
                if (matcher.matches()) break block8;
                return null;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return null;
            }
        }
        System.out.println("frameID:" + frameId);
        int qw = frameHead[4];
        int bw = frameHead[5];
        int sw = frameHead[6];
        int gw = frameHead[7];
        if (qw < 0) {
            qw = Math.abs(qw) + 128;
        }
        if (bw < 0) {
            bw = Math.abs(bw) + 128;
        }
        if (sw < 0) {
            sw = Math.abs(sw) + 128;
        }
        if (gw < 0) {
            gw = Math.abs(gw) + 128;
        }
        int frameContentSize = qw * 0x1000000 + bw * 65536 + sw * 256 + gw - 1;
        byte[] flag = new byte[]{frameHead[8], frameHead[9]};
        FrameInfo frameInfo = new FrameInfo();
        frameInfo.setFrameId(frameId);
        frameInfo.setFrameContentSize(frameContentSize);
        frameInfo.setFlag(flag);
        return frameInfo;
    }

    public String toString() {
        return this.toString("UTF-16");
    }

    public String toString(String charset) {
        return "title:" + this.getTitle(charset) + "\nperformer:" + this.getPerformer(charset) + "\nalbum:" + this.getAlbum(charset);
    }
}

