/*
 * Decompiled with CFR 0.152.
 */
package com.flyfox.util.serializable;

import com.flyfox.util.serializable.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class JavaSerializer
implements Serializer {
    @Override
    public byte[] serialize(Object obj) throws IOException {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public <T> T deserialize(byte[] bits) throws IOException {
        if (bits == null || bits.length == 0) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bits);
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("\u6ca1\u6709\u627e\u5230\u7c7b\u578b", e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                throw new IOException("deserialize\u5173\u95ed\u5931\u8d25", e);
            }
        }
    }
}

