/*
 * Decompiled with CFR 0.152.
 */
package com.jraska.livedata;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import androidx.core.util.Consumer;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class TestObserver<T>
implements Observer<T> {
    private final List<T> valueHistory = new ArrayList<T>();
    private final List<Consumer<T>> onChanged = new ArrayList<Consumer<T>>();
    private CountDownLatch valueLatch = new CountDownLatch(1);

    private TestObserver() {
    }

    public void onChanged(@Nullable T value) {
        this.valueHistory.add(value);
        this.valueLatch.countDown();
        for (Consumer<T> consumer : this.onChanged) {
            consumer.accept(value);
        }
    }

    public T value() {
        this.assertHasValue();
        return this.valueHistory.get(this.valueHistory.size() - 1);
    }

    public List<T> valueHistory() {
        return Collections.unmodifiableList(this.valueHistory);
    }

    public TestObserver<T> assertHasValue() {
        if (this.valueHistory.isEmpty()) {
            throw this.fail("Observer never received any value");
        }
        return this;
    }

    public TestObserver<T> assertNoValue() {
        if (!this.valueHistory.isEmpty()) {
            throw this.fail("Expected no value, but received: " + this.value());
        }
        return this;
    }

    public TestObserver<T> assertHistorySize(int expectedSize) {
        int size = this.valueHistory.size();
        if (size != expectedSize) {
            throw this.fail("History size differ; Expected: " + expectedSize + ", Actual: " + size);
        }
        return this;
    }

    public TestObserver<T> assertValue(T expected) {
        T value = this.value();
        if (TestObserver.notEquals(value, expected)) {
            throw this.fail("Expected: " + TestObserver.valueAndClass(expected) + ", Actual: " + TestObserver.valueAndClass(value));
        }
        return this;
    }

    public TestObserver<T> assertValue(@NonNull Function<T, Boolean> valuePredicate) {
        T value = this.value();
        if (!((Boolean)valuePredicate.apply(value)).booleanValue()) {
            throw this.fail("Value " + TestObserver.valueAndClass(value) + " does not match the predicate " + valuePredicate.toString() + ".");
        }
        return this;
    }

    public TestObserver<T> assertValueHistory(T ... values) {
        List<T> valueHistory = this.valueHistory();
        int size = valueHistory.size();
        if (size != values.length) {
            throw this.fail("Value count differs; expected: " + values.length + " " + Arrays.toString(values) + " but was: " + size + " " + this.valueHistory);
        }
        for (int valueIndex = 0; valueIndex < size; ++valueIndex) {
            T expectedItem = values[valueIndex];
            T historyItem = valueHistory.get(valueIndex);
            if (!TestObserver.notEquals(expectedItem, historyItem)) continue;
            throw this.fail("Values at position " + valueIndex + " differ; expected: " + TestObserver.valueAndClass(expectedItem) + " but was: " + TestObserver.valueAndClass(historyItem));
        }
        return this;
    }

    public TestObserver<T> assertNever(Function<T, Boolean> valuePredicate) {
        int size = this.valueHistory.size();
        for (int valueIndex = 0; valueIndex < size; ++valueIndex) {
            T value = this.valueHistory.get(valueIndex);
            if (!((Boolean)valuePredicate.apply(value)).booleanValue()) continue;
            throw this.fail("Value at position " + valueIndex + " matches predicate " + valuePredicate.toString() + ", which was not expected.");
        }
        return this;
    }

    public <N> TestObserver<N> map(Function<T, N> mapper) {
        TestObserver<Object> newObserver = TestObserver.create();
        for (T value : this.valueHistory) {
            newObserver.onChanged(mapper.apply(value));
        }
        this.doOnChanged(new Map<T, T>(newObserver, mapper));
        return newObserver;
    }

    public TestObserver<T> doOnChanged(Consumer<T> onChanged) {
        this.onChanged.add(onChanged);
        return this;
    }

    public TestObserver<T> awaitValue() throws InterruptedException {
        this.valueLatch.await();
        return this;
    }

    public TestObserver<T> awaitValue(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.valueLatch.await(timeout, timeUnit);
        return this;
    }

    public TestObserver<T> awaitNextValue() throws InterruptedException {
        return this.withNewLatch().awaitValue();
    }

    public TestObserver<T> awaitNextValue(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.withNewLatch().awaitValue(timeout, timeUnit);
    }

    private TestObserver<T> withNewLatch() {
        this.valueLatch = new CountDownLatch(1);
        return this;
    }

    private AssertionError fail(String message) {
        return new AssertionError((Object)message);
    }

    private static boolean notEquals(Object o1, Object o2) {
        return o1 != o2 && (o1 == null || !o1.equals(o2));
    }

    private static String valueAndClass(Object value) {
        if (value != null) {
            return value + " (class: " + value.getClass().getSimpleName() + ")";
        }
        return "null";
    }

    public static <T> TestObserver<T> create() {
        return new TestObserver<T>();
    }

    public static <T> TestObserver<T> test(LiveData<T> liveData) {
        TestObserver<T> observer = new TestObserver<T>();
        liveData.observeForever(observer);
        return observer;
    }

    static final class Map<T, N>
    implements Consumer<T> {
        private final TestObserver<N> newObserver;
        private final Function<T, N> mapper;

        Map(TestObserver<N> newObserver, Function<T, N> mapper) {
            this.newObserver = newObserver;
            this.mapper = mapper;
        }

        public void accept(T value) {
            this.newObserver.onChanged(this.mapper.apply(value));
        }
    }
}

