/*
 * Decompiled with CFR 0.152.
 */
package com.jzxiang.pickerview;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.jzxiang.pickerview.R;
import com.jzxiang.pickerview.TimeWheel;
import com.jzxiang.pickerview.config.PickerConfig;
import com.jzxiang.pickerview.data.Type;
import com.jzxiang.pickerview.data.WheelCalendar;
import com.jzxiang.pickerview.listener.OnDateSetListener;
import java.util.Calendar;

public class TimePickerDialog
extends DialogFragment
implements View.OnClickListener {
    PickerConfig mPickerConfig;
    private TimeWheel mTimeWheel;
    private long mCurrentMillSeconds;

    private static TimePickerDialog newIntance(PickerConfig pickerConfig) {
        TimePickerDialog timePickerDialog = new TimePickerDialog();
        timePickerDialog.initialize(pickerConfig);
        return timePickerDialog;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
    }

    public void onResume() {
        super.onResume();
        int height = this.getResources().getDimensionPixelSize(R.dimen.picker_height);
        Window window = this.getDialog().getWindow();
        window.setLayout(-1, height);
        window.setGravity(80);
    }

    private void initialize(PickerConfig pickerConfig) {
        this.mPickerConfig = pickerConfig;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = new Dialog((Context)this.getActivity(), R.style.Dialog_NoTitle);
        dialog.requestWindowFeature(1);
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        dialog.setContentView(this.initView());
        return dialog;
    }

    View initView() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        View view = inflater.inflate(R.layout.timepicker_layout, null);
        TextView cancel = (TextView)view.findViewById(R.id.tv_cancel);
        cancel.setOnClickListener((View.OnClickListener)this);
        TextView sure = (TextView)view.findViewById(R.id.tv_sure);
        sure.setOnClickListener((View.OnClickListener)this);
        TextView title = (TextView)view.findViewById(R.id.tv_title);
        View toolbar = view.findViewById(R.id.toolbar);
        title.setText((CharSequence)this.mPickerConfig.mTitleString);
        cancel.setText((CharSequence)this.mPickerConfig.mCancelString);
        sure.setText((CharSequence)this.mPickerConfig.mSureString);
        toolbar.setBackgroundColor(this.mPickerConfig.mThemeColor);
        this.mTimeWheel = new TimeWheel(view, this.mPickerConfig);
        return view;
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.tv_cancel) {
            this.dismiss();
        } else if (i == R.id.tv_sure) {
            this.sureClicked();
        }
    }

    public long getCurrentMillSeconds() {
        if (this.mCurrentMillSeconds == 0L) {
            return System.currentTimeMillis();
        }
        return this.mCurrentMillSeconds;
    }

    void sureClicked() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, this.mTimeWheel.getCurrentYear());
        calendar.set(2, this.mTimeWheel.getCurrentMonth() - 1);
        calendar.set(5, this.mTimeWheel.getCurrentDay());
        calendar.set(11, this.mTimeWheel.getCurrentHour());
        calendar.set(12, this.mTimeWheel.getCurrentMinute());
        this.mCurrentMillSeconds = calendar.getTimeInMillis();
        if (this.mPickerConfig.mCallBack != null) {
            this.mPickerConfig.mCallBack.onDateSet(this, this.mCurrentMillSeconds);
        }
        this.dismiss();
    }

    public static class Builder {
        PickerConfig mPickerConfig = new PickerConfig();

        public Builder setType(Type type) {
            this.mPickerConfig.mType = type;
            return this;
        }

        public Builder setThemeColor(int color) {
            this.mPickerConfig.mThemeColor = color;
            return this;
        }

        public Builder setCancelStringId(String left) {
            this.mPickerConfig.mCancelString = left;
            return this;
        }

        public Builder setSureStringId(String right) {
            this.mPickerConfig.mSureString = right;
            return this;
        }

        public Builder setTitleStringId(String title) {
            this.mPickerConfig.mTitleString = title;
            return this;
        }

        public Builder setToolBarTextColor(int color) {
            this.mPickerConfig.mToolBarTVColor = color;
            return this;
        }

        public Builder setWheelItemTextNormalColor(int color) {
            this.mPickerConfig.mWheelTVNormalColor = color;
            return this;
        }

        public Builder setWheelItemTextSelectorColor(int color) {
            this.mPickerConfig.mWheelTVSelectorColor = color;
            return this;
        }

        public Builder setWheelItemTextSize(int size) {
            this.mPickerConfig.mWheelTVSize = size;
            return this;
        }

        public Builder setCyclic(boolean cyclic) {
            this.mPickerConfig.cyclic = cyclic;
            return this;
        }

        public Builder setMinMillseconds(long millseconds) {
            this.mPickerConfig.mMinCalendar = new WheelCalendar(millseconds);
            return this;
        }

        public Builder setMaxMillseconds(long millseconds) {
            this.mPickerConfig.mMaxCalendar = new WheelCalendar(millseconds);
            return this;
        }

        public Builder setCurrentMillseconds(long millseconds) {
            this.mPickerConfig.mCurrentCalendar = new WheelCalendar(millseconds);
            return this;
        }

        public Builder setYearText(String year) {
            this.mPickerConfig.mYear = year;
            return this;
        }

        public Builder setMonthText(String month) {
            this.mPickerConfig.mMonth = month;
            return this;
        }

        public Builder setDayText(String day) {
            this.mPickerConfig.mDay = day;
            return this;
        }

        public Builder setHourText(String hour) {
            this.mPickerConfig.mHour = hour;
            return this;
        }

        public Builder setMinuteText(String minute) {
            this.mPickerConfig.mMinute = minute;
            return this;
        }

        public Builder setCallBack(OnDateSetListener listener) {
            this.mPickerConfig.mCallBack = listener;
            return this;
        }

        public TimePickerDialog build() {
            return TimePickerDialog.newIntance(this.mPickerConfig);
        }
    }
}

