/*
 * Decompiled with CFR 0.152.
 */
package com.jzxiang.pickerview;

import android.content.Context;
import android.view.View;
import com.jzxiang.pickerview.R;
import com.jzxiang.pickerview.adapters.NumericWheelAdapter;
import com.jzxiang.pickerview.config.PickerConfig;
import com.jzxiang.pickerview.data.source.TimeRepository;
import com.jzxiang.pickerview.utils.Utils;
import com.jzxiang.pickerview.wheel.OnWheelChangedListener;
import com.jzxiang.pickerview.wheel.WheelView;
import java.util.Calendar;

public class TimeWheel {
    Context mContext;
    WheelView year;
    WheelView month;
    WheelView day;
    WheelView hour;
    WheelView minute;
    NumericWheelAdapter mYearAdapter;
    NumericWheelAdapter mMonthAdapter;
    NumericWheelAdapter mDayAdapter;
    NumericWheelAdapter mHourAdapter;
    NumericWheelAdapter mMinuteAdapter;
    PickerConfig mPickerConfig;
    TimeRepository mRepository;
    OnWheelChangedListener yearListener = new OnWheelChangedListener(){

        @Override
        public void onChanged(WheelView wheel, int oldValue, int newValue) {
            TimeWheel.this.updateMonths();
        }
    };
    OnWheelChangedListener monthListener = new OnWheelChangedListener(){

        @Override
        public void onChanged(WheelView wheel, int oldValue, int newValue) {
            TimeWheel.this.updateDays();
        }
    };
    OnWheelChangedListener dayListener = new OnWheelChangedListener(){

        @Override
        public void onChanged(WheelView wheel, int oldValue, int newValue) {
            TimeWheel.this.updateHours();
        }
    };
    OnWheelChangedListener minuteListener = new OnWheelChangedListener(){

        @Override
        public void onChanged(WheelView wheel, int oldValue, int newValue) {
            TimeWheel.this.updateMinutes();
        }
    };

    public TimeWheel(View view, PickerConfig pickerConfig) {
        this.mPickerConfig = pickerConfig;
        this.mRepository = new TimeRepository(pickerConfig);
        this.mContext = view.getContext();
        this.initialize(view);
    }

    public void initialize(View view) {
        this.initView(view);
        this.initYear();
        this.initMonth();
        this.initDay();
        this.initHour();
        this.initMinute();
    }

    void initView(View view) {
        this.year = (WheelView)view.findViewById(R.id.year);
        this.month = (WheelView)view.findViewById(R.id.month);
        this.day = (WheelView)view.findViewById(R.id.day);
        this.hour = (WheelView)view.findViewById(R.id.hour);
        this.minute = (WheelView)view.findViewById(R.id.minute);
        switch (this.mPickerConfig.mType) {
            case ALL: {
                break;
            }
            case YEAR_MONTH_DAY: {
                Utils.hideViews(this.hour, this.minute);
                break;
            }
            case YEAR_MONTH: {
                Utils.hideViews(this.day, this.hour, this.minute);
                break;
            }
            case MONTH_DAY_HOUR_MIN: {
                Utils.hideViews(this.year);
                break;
            }
            case HOURS_MINS: {
                Utils.hideViews(this.year, this.month, this.day);
                break;
            }
            case YEAR: {
                Utils.hideViews(this.month, this.day, this.hour, this.minute);
            }
        }
        this.year.addChangingListener(this.yearListener);
        this.year.addChangingListener(this.monthListener);
        this.year.addChangingListener(this.dayListener);
        this.year.addChangingListener(this.minuteListener);
        this.month.addChangingListener(this.monthListener);
        this.month.addChangingListener(this.dayListener);
        this.month.addChangingListener(this.minuteListener);
        this.day.addChangingListener(this.dayListener);
        this.day.addChangingListener(this.minuteListener);
        this.hour.addChangingListener(this.minuteListener);
    }

    void initYear() {
        int minYear = this.mRepository.getMinYear();
        int maxYear = this.mRepository.getMaxYear();
        this.mYearAdapter = new NumericWheelAdapter(this.mContext, minYear, maxYear, "%02d", this.mPickerConfig.mYear);
        this.mYearAdapter.setConfig(this.mPickerConfig);
        this.year.setViewAdapter(this.mYearAdapter);
        this.year.setCurrentItem(this.mRepository.getDefaultCalendar().year - minYear);
    }

    void initMonth() {
        this.updateMonths();
        int curYear = this.getCurrentYear();
        int minMonth = this.mRepository.getMinMonth(curYear);
        this.month.setCurrentItem(this.mRepository.getDefaultCalendar().month - minMonth);
        this.month.setCyclic(this.mPickerConfig.cyclic);
    }

    void initDay() {
        this.updateDays();
        int curYear = this.getCurrentYear();
        int curMonth = this.getCurrentMonth();
        int minDay = this.mRepository.getMinDay(curYear, curMonth);
        this.day.setCurrentItem(this.mRepository.getDefaultCalendar().day - minDay);
        this.day.setCyclic(this.mPickerConfig.cyclic);
    }

    void initHour() {
        this.updateHours();
        int curYear = this.getCurrentYear();
        int curMonth = this.getCurrentMonth();
        int curDay = this.getCurrentDay();
        int minHour = this.mRepository.getMinHour(curYear, curMonth, curDay);
        this.hour.setCurrentItem(this.mRepository.getDefaultCalendar().hour - minHour);
        this.hour.setCyclic(this.mPickerConfig.cyclic);
    }

    void initMinute() {
        this.updateMinutes();
        int curYear = this.getCurrentYear();
        int curMonth = this.getCurrentMonth();
        int curDay = this.getCurrentDay();
        int curHour = this.getCurrentHour();
        int minMinute = this.mRepository.getMinMinute(curYear, curMonth, curDay, curHour);
        this.minute.setCurrentItem(this.mRepository.getDefaultCalendar().minute - minMinute);
        this.minute.setCyclic(this.mPickerConfig.cyclic);
    }

    void updateMonths() {
        if (this.month.getVisibility() == 8) {
            return;
        }
        int curYear = this.getCurrentYear();
        int minMonth = this.mRepository.getMinMonth(curYear);
        int maxMonth = this.mRepository.getMaxMonth(curYear);
        this.mMonthAdapter = new NumericWheelAdapter(this.mContext, minMonth, maxMonth, "%02d", this.mPickerConfig.mMonth);
        this.mMonthAdapter.setConfig(this.mPickerConfig);
        this.month.setViewAdapter(this.mMonthAdapter);
        if (this.mRepository.isMinYear(curYear)) {
            this.month.setCurrentItem(0, false);
        }
    }

    void updateDays() {
        if (this.day.getVisibility() == 8) {
            return;
        }
        int curYear = this.getCurrentYear();
        int curMonth = this.getCurrentMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, calendar.get(1) + this.year.getCurrentItem());
        calendar.set(2, curMonth);
        int maxDay = this.mRepository.getMaxDay(curYear, curMonth);
        int minDay = this.mRepository.getMinDay(curYear, curMonth);
        this.mDayAdapter = new NumericWheelAdapter(this.mContext, minDay, maxDay, "%02d", this.mPickerConfig.mDay);
        this.mDayAdapter.setConfig(this.mPickerConfig);
        this.day.setViewAdapter(this.mDayAdapter);
        if (this.mRepository.isMinMonth(curYear, curMonth)) {
            this.day.setCurrentItem(0, true);
        }
        int dayCount = this.mDayAdapter.getItemsCount();
        if (this.day.getCurrentItem() >= dayCount) {
            this.day.setCurrentItem(dayCount - 1, true);
        }
    }

    void updateHours() {
        if (this.hour.getVisibility() == 8) {
            return;
        }
        int curYear = this.getCurrentYear();
        int curMonth = this.getCurrentMonth();
        int curDay = this.getCurrentDay();
        int minHour = this.mRepository.getMinHour(curYear, curMonth, curDay);
        int maxHour = this.mRepository.getMaxHour(curYear, curMonth, curDay);
        this.mHourAdapter = new NumericWheelAdapter(this.mContext, minHour, maxHour, "%02d", this.mPickerConfig.mHour);
        this.mHourAdapter.setConfig(this.mPickerConfig);
        this.hour.setViewAdapter(this.mHourAdapter);
        if (this.mRepository.isMinDay(curYear, curMonth, curDay)) {
            this.hour.setCurrentItem(0, false);
        }
    }

    void updateMinutes() {
        if (this.minute.getVisibility() == 8) {
            return;
        }
        int curYear = this.getCurrentYear();
        int curMonth = this.getCurrentMonth();
        int curDay = this.getCurrentDay();
        int curHour = this.getCurrentHour();
        int minMinute = this.mRepository.getMinMinute(curYear, curMonth, curDay, curHour);
        int maxMinute = this.mRepository.getMaxMinute(curYear, curMonth, curDay, curHour);
        this.mMinuteAdapter = new NumericWheelAdapter(this.mContext, minMinute, maxMinute, "%02d", this.mPickerConfig.mMinute);
        this.mMinuteAdapter.setConfig(this.mPickerConfig);
        this.minute.setViewAdapter(this.mMinuteAdapter);
        if (this.mRepository.isMinHour(curYear, curMonth, curDay, curHour)) {
            this.minute.setCurrentItem(0, false);
        }
    }

    public int getCurrentYear() {
        return this.year.getCurrentItem() + this.mRepository.getMinYear();
    }

    public int getCurrentMonth() {
        int curYear = this.getCurrentYear();
        return this.month.getCurrentItem() + this.mRepository.getMinMonth(curYear);
    }

    public int getCurrentDay() {
        int curYear = this.getCurrentYear();
        int curMonth = this.getCurrentMonth();
        return this.day.getCurrentItem() + this.mRepository.getMinDay(curYear, curMonth);
    }

    public int getCurrentHour() {
        int curYear = this.getCurrentYear();
        int curMonth = this.getCurrentMonth();
        int curDay = this.getCurrentDay();
        return this.hour.getCurrentItem() + this.mRepository.getMinHour(curYear, curMonth, curDay);
    }

    public int getCurrentMinute() {
        int curYear = this.getCurrentYear();
        int curMonth = this.getCurrentMonth();
        int curDay = this.getCurrentDay();
        int curHour = this.getCurrentHour();
        return this.minute.getCurrentItem() + this.mRepository.getMinMinute(curYear, curMonth, curDay, curHour);
    }
}

