/*
 * Decompiled with CFR 0.152.
 */
package com.jzxiang.pickerview.adapters;

import android.content.Context;
import android.text.TextUtils;
import com.jzxiang.pickerview.adapters.AbstractWheelTextAdapter;

public class NumericWheelAdapter
extends AbstractWheelTextAdapter {
    public static final int DEFAULT_MAX_VALUE = 9;
    private static final int DEFAULT_MIN_VALUE = 0;
    private int minValue;
    private int maxValue;
    private String format;
    private String unit;

    public NumericWheelAdapter(Context context) {
        this(context, 0, 9);
    }

    public NumericWheelAdapter(Context context, int minValue, int maxValue) {
        this(context, minValue, maxValue, null);
    }

    public NumericWheelAdapter(Context context, int minValue, int maxValue, String format) {
        this(context, minValue, maxValue, format, null);
    }

    public NumericWheelAdapter(Context context, int minValue, int maxValue, String format, String unit) {
        super(context);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.format = format;
        this.unit = unit;
    }

    @Override
    public CharSequence getItemText(int index) {
        if (index >= 0 && index < this.getItemsCount()) {
            int value = this.minValue + index;
            String text = !TextUtils.isEmpty((CharSequence)this.format) ? String.format(this.format, value) : Integer.toString(value);
            text = TextUtils.isEmpty((CharSequence)this.unit) ? text : text + this.unit;
            return text;
        }
        return null;
    }

    @Override
    public int getItemsCount() {
        return this.maxValue - this.minValue + 1;
    }
}

