/*
 * Decompiled with CFR 0.152.
 */
package com.jzxiang.pickerview.data.source;

import com.jzxiang.pickerview.config.PickerConfig;
import com.jzxiang.pickerview.data.WheelCalendar;
import com.jzxiang.pickerview.data.source.TimeDataSource;
import com.jzxiang.pickerview.utils.Utils;
import java.util.Calendar;

public class TimeRepository
implements TimeDataSource {
    PickerConfig mPickerConfig;
    WheelCalendar mCalendarMin;
    WheelCalendar mCalendarMax;
    boolean mIsMinNoRange;
    boolean mIsMaxNoRange;

    public TimeRepository(PickerConfig pickerConfig) {
        this.mPickerConfig = pickerConfig;
        this.mCalendarMin = pickerConfig.mMinCalendar;
        this.mCalendarMax = pickerConfig.mMaxCalendar;
        this.mIsMinNoRange = this.mCalendarMin.isNoRange();
        this.mIsMaxNoRange = this.mCalendarMax.isNoRange();
    }

    @Override
    public int getMinYear() {
        if (this.mIsMinNoRange) {
            return 2015;
        }
        return this.mCalendarMin.year;
    }

    @Override
    public int getMaxYear() {
        if (this.mIsMaxNoRange) {
            return this.getMinYear() + 50;
        }
        return this.mCalendarMax.year;
    }

    @Override
    public int getMinMonth(int year) {
        if (!this.mIsMinNoRange && Utils.isTimeEquals(this.mCalendarMin, year)) {
            return this.mCalendarMin.month;
        }
        return 1;
    }

    @Override
    public int getMaxMonth(int year) {
        if (!this.mIsMaxNoRange && Utils.isTimeEquals(this.mCalendarMax, year)) {
            return this.mCalendarMax.month;
        }
        return 12;
    }

    @Override
    public int getMinDay(int year, int month) {
        if (!this.mIsMinNoRange && Utils.isTimeEquals(this.mCalendarMin, year, month)) {
            return this.mCalendarMin.day;
        }
        return 1;
    }

    @Override
    public int getMaxDay(int year, int month) {
        if (!this.mIsMaxNoRange && Utils.isTimeEquals(this.mCalendarMax, year, month)) {
            return this.mCalendarMax.day;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(5, 1);
        calendar.set(2, month - 1);
        return calendar.getActualMaximum(5);
    }

    @Override
    public int getMinHour(int year, int month, int day) {
        if (!this.mIsMinNoRange && Utils.isTimeEquals(this.mCalendarMin, year, month, day)) {
            return this.mCalendarMin.hour;
        }
        return 0;
    }

    @Override
    public int getMaxHour(int year, int month, int day) {
        if (!this.mIsMaxNoRange && Utils.isTimeEquals(this.mCalendarMax, year, month, day)) {
            return this.mCalendarMax.hour;
        }
        return 23;
    }

    @Override
    public int getMinMinute(int year, int month, int day, int hour) {
        if (!this.mIsMinNoRange && Utils.isTimeEquals(this.mCalendarMin, year, month, day, hour)) {
            return this.mCalendarMin.minute + 1;
        }
        return 0;
    }

    @Override
    public int getMaxMinute(int year, int month, int day, int hour) {
        if (!this.mIsMaxNoRange && Utils.isTimeEquals(this.mCalendarMax, year, month, day, hour)) {
            return this.mCalendarMax.minute;
        }
        return 59;
    }

    @Override
    public boolean isMinYear(int year) {
        return Utils.isTimeEquals(this.mCalendarMin, year);
    }

    @Override
    public boolean isMinMonth(int year, int month) {
        return Utils.isTimeEquals(this.mCalendarMin, year, month);
    }

    @Override
    public boolean isMinDay(int year, int month, int day) {
        return Utils.isTimeEquals(this.mCalendarMin, year, month, day);
    }

    @Override
    public boolean isMinHour(int year, int month, int day, int hour) {
        return Utils.isTimeEquals(this.mCalendarMin, year, month, day, hour);
    }

    @Override
    public WheelCalendar getDefaultCalendar() {
        return this.mPickerConfig.mCurrentCalendar;
    }
}

