/*
 * Decompiled with CFR 0.152.
 */
package com.karumi.dexter;

import com.karumi.dexter.listener.PermissionDeniedResponse;
import com.karumi.dexter.listener.PermissionGrantedResponse;
import java.util.LinkedList;
import java.util.List;

public final class MultiplePermissionsReport {
    private final List<PermissionGrantedResponse> grantedPermissionResponses = new LinkedList<PermissionGrantedResponse>();
    private final List<PermissionDeniedResponse> deniedPermissionResponses = new LinkedList<PermissionDeniedResponse>();

    MultiplePermissionsReport() {
    }

    public List<PermissionGrantedResponse> getGrantedPermissionResponses() {
        return this.grantedPermissionResponses;
    }

    public List<PermissionDeniedResponse> getDeniedPermissionResponses() {
        return this.deniedPermissionResponses;
    }

    public boolean areAllPermissionsGranted() {
        return this.deniedPermissionResponses.isEmpty();
    }

    public boolean isAnyPermissionPermanentlyDenied() {
        boolean bl = false;
        for (PermissionDeniedResponse permissionDeniedResponse : this.deniedPermissionResponses) {
            if (!permissionDeniedResponse.isPermanentlyDenied()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    boolean addGrantedPermissionResponse(PermissionGrantedResponse permissionGrantedResponse) {
        return this.grantedPermissionResponses.add(permissionGrantedResponse);
    }

    boolean addDeniedPermissionResponse(PermissionDeniedResponse permissionDeniedResponse) {
        return this.deniedPermissionResponses.add(permissionDeniedResponse);
    }

    void clear() {
        this.grantedPermissionResponses.clear();
        this.deniedPermissionResponses.clear();
    }
}

