/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.PartShadowContainer;

public abstract class AttachPopupView
extends BasePopupView {
    protected int defaultOffsetY = 0;
    protected int defaultOffsetX = 0;
    protected PartShadowContainer attachPopupContainer;
    public boolean isShowUp;
    public boolean isShowLeft;
    protected int bgDrawableMargin = 6;
    float translationX = 0.0f;
    float translationY = 0.0f;
    float maxY = XPopupUtils.getAppHeight(this.getContext());
    int overflow = XPopupUtils.dp2px(this.getContext(), 10.0f);
    float centerY = 0.0f;

    public AttachPopupView(@NonNull Context context) {
        super(context);
        this.attachPopupContainer = (PartShadowContainer)this.findViewById(R.id.attachPopupContainer);
    }

    protected void addInnerContent() {
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.attachPopupContainer, false);
        this.attachPopupContainer.addView(contentView);
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_attach_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        if (this.attachPopupContainer.getChildCount() == 0) {
            this.addInnerContent();
        }
        if (this.popupInfo.getAtView() == null && this.popupInfo.touchPoint == null) {
            throw new IllegalArgumentException("atView() or watchView() must be call for AttachPopupView before show()\uff01");
        }
        this.defaultOffsetY = this.popupInfo.offsetY == 0 ? XPopupUtils.dp2px(this.getContext(), 4.0f) : this.popupInfo.offsetY;
        this.defaultOffsetX = this.popupInfo.offsetX;
        this.attachPopupContainer.setTranslationX(this.popupInfo.offsetX);
        this.attachPopupContainer.setTranslationY(this.popupInfo.offsetY);
        this.applyBg();
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), this.getPopupWidth(), this.getPopupHeight(), new Runnable(){

            @Override
            public void run() {
                AttachPopupView.this.doAttach();
            }
        });
    }

    protected void applyBg() {
        if (!this.isCreated) {
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.getPopupImplView().getBackground() != null) {
                    Drawable.ConstantState constantState = this.getPopupImplView().getBackground().getConstantState();
                    if (constantState != null) {
                        Drawable newDrawable = constantState.newDrawable();
                        this.attachPopupContainer.setBackground(newDrawable);
                        this.getPopupImplView().setBackground(null);
                    }
                } else {
                    this.attachPopupContainer.setBackground(XPopupUtils.createDrawable(this.getResources().getColor(this.popupInfo.isDarkTheme ? R.color._xpopup_dark_color : R.color._xpopup_light_color), this.popupInfo.borderRadius));
                }
                this.attachPopupContainer.setElevation(XPopupUtils.dp2px(this.getContext(), 20.0f));
            } else if (this.getPopupImplView().getBackground() == null) {
                this.defaultOffsetX -= this.bgDrawableMargin;
                this.defaultOffsetY -= this.bgDrawableMargin;
                this.attachPopupContainer.setBackground(XPopupUtils.createDrawable(this.getResources().getColor(this.popupInfo.isDarkTheme ? R.color._xpopup_dark_color : R.color._xpopup_light_color), this.popupInfo.borderRadius));
            } else {
                Drawable.ConstantState constantState = this.getPopupImplView().getBackground().getConstantState();
                if (constantState != null) {
                    Drawable newDrawable = constantState.newDrawable();
                    this.attachPopupContainer.setBackground(newDrawable);
                    this.getPopupImplView().setBackground(null);
                }
            }
        }
    }

    public void doAttach() {
        this.maxY = XPopupUtils.getAppHeight(this.getContext()) - this.overflow;
        final boolean isRTL = XPopupUtils.isLayoutRtl(this.getContext());
        if (this.popupInfo.touchPoint != null) {
            boolean isTallerThanWindowHeight;
            if (XPopup.longClickPoint != null) {
                this.popupInfo.touchPoint = XPopup.longClickPoint;
            }
            this.centerY = this.popupInfo.touchPoint.y;
            boolean bl = isTallerThanWindowHeight = this.popupInfo.touchPoint.y + (float)this.getPopupContentView().getMeasuredHeight() > this.maxY;
            this.isShowUp = isTallerThanWindowHeight ? this.popupInfo.touchPoint.y > (float)(XPopupUtils.getScreenHeight(this.getContext()) / 2) : false;
            this.isShowLeft = this.popupInfo.touchPoint.x < (float)(XPopupUtils.getWindowWidth(this.getContext()) / 2);
            ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
            int maxHeight = (int)(this.isShowUpToTarget() ? this.popupInfo.touchPoint.y - (float)XPopupUtils.getStatusBarHeight() - (float)this.overflow : (float)XPopupUtils.getScreenHeight(this.getContext()) - this.popupInfo.touchPoint.y - (float)this.overflow);
            int maxWidth = (int)(this.isShowLeft ? (float)XPopupUtils.getWindowWidth(this.getContext()) - this.popupInfo.touchPoint.x - (float)this.overflow : this.popupInfo.touchPoint.x - (float)this.overflow);
            if (this.getPopupContentView().getMeasuredHeight() > maxHeight) {
                params.height = maxHeight;
            }
            if (this.getPopupContentView().getMeasuredWidth() > maxWidth) {
                params.width = maxWidth;
            }
            this.getPopupContentView().setLayoutParams(params);
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    if (isRTL) {
                        AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? -((float)XPopupUtils.getWindowWidth(AttachPopupView.this.getContext()) - AttachPopupView.this.popupInfo.touchPoint.x - (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() - (float)AttachPopupView.this.defaultOffsetX) : -((float)XPopupUtils.getWindowWidth(AttachPopupView.this.getContext()) - AttachPopupView.this.popupInfo.touchPoint.x + (float)AttachPopupView.this.defaultOffsetX);
                    } else {
                        float f = AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? AttachPopupView.this.popupInfo.touchPoint.x + (float)AttachPopupView.this.defaultOffsetX : AttachPopupView.this.popupInfo.touchPoint.x - (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() - (float)AttachPopupView.this.defaultOffsetX;
                    }
                    if (AttachPopupView.this.popupInfo.isCenterHorizontal) {
                        AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? (isRTL ? (AttachPopupView.this.translationX += (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f) : (AttachPopupView.this.translationX -= (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f)) : (isRTL ? (AttachPopupView.this.translationX -= (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f) : (AttachPopupView.this.translationX += (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f));
                    }
                    AttachPopupView.this.translationY = AttachPopupView.this.isShowUpToTarget() ? AttachPopupView.this.popupInfo.touchPoint.y - (float)AttachPopupView.this.getPopupContentView().getMeasuredHeight() - (float)AttachPopupView.this.defaultOffsetY : AttachPopupView.this.popupInfo.touchPoint.y + (float)AttachPopupView.this.defaultOffsetY;
                    AttachPopupView.this.getPopupContentView().setTranslationX(AttachPopupView.this.translationX);
                    AttachPopupView.this.getPopupContentView().setTranslationY(AttachPopupView.this.translationY);
                    AttachPopupView.this.initAndStartAnimation();
                }
            });
        } else {
            int maxWidth;
            int[] locations = new int[2];
            this.popupInfo.getAtView().getLocationOnScreen(locations);
            final Rect rect = new Rect(locations[0], locations[1], locations[0] + this.popupInfo.getAtView().getMeasuredWidth(), locations[1] + this.popupInfo.getAtView().getMeasuredHeight());
            int centerX = (rect.left + rect.right) / 2;
            boolean isTallerThanWindowHeight = (float)(rect.bottom + this.getPopupContentView().getMeasuredHeight()) > this.maxY;
            this.centerY = (rect.top + rect.bottom) / 2;
            this.isShowUp = isTallerThanWindowHeight;
            this.isShowLeft = centerX < XPopupUtils.getWindowWidth(this.getContext()) / 2;
            ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
            int maxHeight = this.isShowUpToTarget() ? rect.top - XPopupUtils.getStatusBarHeight() - this.overflow : XPopupUtils.getScreenHeight(this.getContext()) - rect.bottom - this.overflow;
            int n = maxWidth = this.isShowLeft ? XPopupUtils.getWindowWidth(this.getContext()) - rect.left - this.overflow : rect.right - this.overflow;
            if (this.getPopupContentView().getMeasuredHeight() > maxHeight) {
                params.height = maxHeight;
            }
            if (this.getPopupContentView().getMeasuredWidth() > maxWidth) {
                params.width = maxWidth;
            }
            this.getPopupContentView().setLayoutParams(params);
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    if (isRTL) {
                        AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? (float)(-(XPopupUtils.getWindowWidth(AttachPopupView.this.getContext()) - rect.left - AttachPopupView.this.getPopupContentView().getMeasuredWidth() - AttachPopupView.this.defaultOffsetX)) : (float)(-(XPopupUtils.getWindowWidth(AttachPopupView.this.getContext()) - rect.right + AttachPopupView.this.defaultOffsetX));
                    } else {
                        float f = AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? (float)(rect.left + AttachPopupView.this.defaultOffsetX) : (float)(rect.right - AttachPopupView.this.getPopupContentView().getMeasuredWidth() - AttachPopupView.this.defaultOffsetX);
                    }
                    if (AttachPopupView.this.popupInfo.isCenterHorizontal) {
                        AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? (isRTL ? (AttachPopupView.this.translationX -= (float)(rect.width() - AttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f) : (AttachPopupView.this.translationX += (float)(rect.width() - AttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f)) : (isRTL ? (AttachPopupView.this.translationX += (float)(rect.width() - AttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f) : (AttachPopupView.this.translationX -= (float)(rect.width() - AttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f));
                    }
                    AttachPopupView.this.translationY = AttachPopupView.this.isShowUpToTarget() ? (float)(rect.top - AttachPopupView.this.getPopupContentView().getMeasuredHeight() - AttachPopupView.this.defaultOffsetY) : (float)(rect.bottom + AttachPopupView.this.defaultOffsetY);
                    AttachPopupView.this.getPopupContentView().setTranslationX(AttachPopupView.this.translationX);
                    AttachPopupView.this.getPopupContentView().setTranslationY(AttachPopupView.this.translationY);
                    AttachPopupView.this.initAndStartAnimation();
                }
            });
        }
    }

    protected void initAndStartAnimation() {
        this.initAnimator();
        this.doShowAnimation();
        this.doAfterShow();
    }

    protected boolean isShowUpToTarget() {
        if (this.popupInfo.positionByWindowCenter) {
            return this.centerY > (float)(XPopupUtils.getAppHeight(this.getContext()) / 2);
        }
        return (this.isShowUp || this.popupInfo.popupPosition == PopupPosition.Top) && this.popupInfo.popupPosition != PopupPosition.Bottom;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        ScrollScaleAnimator animator = this.isShowUpToTarget() ? new ScrollScaleAnimator(this.getPopupContentView(), this.isShowLeft ? PopupAnimation.ScrollAlphaFromLeftBottom : PopupAnimation.ScrollAlphaFromRightBottom) : new ScrollScaleAnimator(this.getPopupContentView(), this.isShowLeft ? PopupAnimation.ScrollAlphaFromLeftTop : PopupAnimation.ScrollAlphaFromRightTop);
        return animator;
    }
}

