/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.LinearLayout;
import android.widget.OverScroller;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.ViewCompat;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.enums.LayoutStatus;
import com.lxj.xpopup.util.XPopupUtils;

public class SmartDragLayout
extends LinearLayout
implements NestedScrollingParent {
    private View child;
    OverScroller scroller;
    VelocityTracker tracker;
    boolean enableDrag = true;
    boolean dismissOnTouchOutside = true;
    boolean isUserClose = false;
    boolean isThreeDrag = false;
    LayoutStatus status = LayoutStatus.Close;
    int maxY;
    int minY;
    int lastHeight;
    float touchX;
    float touchY;
    boolean isScrollUp;
    private OnCloseListener listener;

    public SmartDragLayout(Context context) {
        this(context, null);
    }

    public SmartDragLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmartDragLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.enableDrag) {
            this.scroller = new OverScroller(context);
        }
    }

    public void onViewAdded(View c) {
        super.onViewAdded(c);
        this.child = c;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.maxY = this.child.getMeasuredHeight();
        this.minY = 0;
        int l = this.getMeasuredWidth() / 2 - this.child.getMeasuredWidth() / 2;
        this.child.layout(l, this.getMeasuredHeight(), l + this.child.getMeasuredWidth(), this.getMeasuredHeight() + this.maxY);
        if (this.status == LayoutStatus.Open) {
            if (this.isThreeDrag) {
                this.scrollTo(this.getScrollX(), this.getScrollY() - (this.lastHeight - this.maxY));
            } else {
                this.scrollTo(this.getScrollX(), this.getScrollY() - (this.lastHeight - this.maxY));
            }
        }
        this.lastHeight = this.maxY;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.isUserClose = true;
        return super.dispatchTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.enableDrag && this.scroller.computeScrollOffset()) {
            this.touchX = 0.0f;
            this.touchY = 0.0f;
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.enableDrag) {
                    if (this.tracker != null) {
                        this.tracker.clear();
                    }
                    this.tracker = VelocityTracker.obtain();
                }
                this.touchX = event.getX();
                this.touchY = event.getY();
                break;
            }
            case 2: {
                if (!this.enableDrag || this.tracker == null) break;
                this.tracker.addMovement(event);
                this.tracker.computeCurrentVelocity(1000);
                int dy = (int)(event.getY() - this.touchY);
                this.scrollTo(this.getScrollX(), this.getScrollY() - dy);
                this.touchY = event.getY();
                break;
            }
            case 1: 
            case 3: {
                float distance;
                Rect rect = new Rect();
                this.child.getGlobalVisibleRect(rect);
                if (!XPopupUtils.isInRect(event.getRawX(), event.getRawY(), rect) && this.dismissOnTouchOutside && (distance = (float)Math.sqrt(Math.pow(event.getX() - this.touchX, 2.0) + Math.pow(event.getY() - this.touchY, 2.0))) < (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop()) {
                    this.performClick();
                }
                if (!this.enableDrag || this.tracker == null) break;
                float yVelocity = this.tracker.getYVelocity();
                if (yVelocity > 1500.0f && !this.isThreeDrag) {
                    this.close();
                } else {
                    this.finishScroll();
                }
                this.tracker = null;
            }
        }
        return true;
    }

    private void finishScroll() {
        if (this.enableDrag) {
            int threshold = this.isScrollUp ? (this.maxY - this.minY) / 3 : (this.maxY - this.minY) * 2 / 3;
            int dy = (this.getScrollY() > threshold ? this.maxY : this.minY) - this.getScrollY();
            if (this.isThreeDrag) {
                int per = this.maxY / 3;
                dy = (float)this.getScrollY() > (float)per * 2.5f ? this.maxY - this.getScrollY() : ((float)this.getScrollY() <= (float)per * 2.5f && (float)this.getScrollY() > (float)per * 1.5f ? per * 2 - this.getScrollY() : (this.getScrollY() > per ? per - this.getScrollY() : this.minY - this.getScrollY()));
            }
            this.scroller.startScroll(this.getScrollX(), this.getScrollY(), 0, dy, XPopup.getAnimationDuration());
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void scrollTo(int x, int y) {
        if (y > this.maxY) {
            y = this.maxY;
        }
        if (y < this.minY) {
            y = this.minY;
        }
        float fraction = (float)(y - this.minY) * 1.0f / (float)(this.maxY - this.minY);
        boolean bl = this.isScrollUp = y > this.getScrollY();
        if (this.listener != null) {
            if (this.isUserClose && fraction == 0.0f && this.status != LayoutStatus.Close) {
                this.status = LayoutStatus.Close;
                this.listener.onClose();
            } else if (fraction == 1.0f && this.status != LayoutStatus.Open) {
                this.status = LayoutStatus.Open;
                this.listener.onOpen();
            }
            this.listener.onDrag(y, fraction, this.isScrollUp);
        }
        super.scrollTo(x, y);
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.scroller.computeScrollOffset()) {
            this.scrollTo(this.scroller.getCurrX(), this.scroller.getCurrY());
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isScrollUp = false;
        this.isUserClose = false;
        this.setTranslationY(0.0f);
    }

    public void open() {
        this.post(new Runnable(){

            @Override
            public void run() {
                int dy = SmartDragLayout.this.maxY - SmartDragLayout.this.getScrollY();
                SmartDragLayout.this.smoothScroll(SmartDragLayout.this.enableDrag && SmartDragLayout.this.isThreeDrag ? dy / 3 : dy, true);
                SmartDragLayout.this.status = LayoutStatus.Opening;
            }
        });
    }

    public void close() {
        this.isUserClose = true;
        this.post(new Runnable(){

            @Override
            public void run() {
                SmartDragLayout.this.scroller.abortAnimation();
                SmartDragLayout.this.smoothScroll(SmartDragLayout.this.minY - SmartDragLayout.this.getScrollY(), false);
                SmartDragLayout.this.status = LayoutStatus.Closing;
            }
        });
    }

    public void smoothScroll(final int dy, final boolean isOpen) {
        this.post(new Runnable(){

            @Override
            public void run() {
                SmartDragLayout.this.scroller.startScroll(SmartDragLayout.this.getScrollX(), SmartDragLayout.this.getScrollY(), 0, dy, (int)(isOpen ? (float)XPopup.getAnimationDuration() : (float)XPopup.getAnimationDuration() * 0.8f));
                ViewCompat.postInvalidateOnAnimation((View)SmartDragLayout.this);
            }
        });
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return nestedScrollAxes == 2 && this.enableDrag;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.scroller.abortAnimation();
    }

    public void onStopNestedScroll(View target) {
        this.finishScroll();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.scrollTo(this.getScrollX(), this.getScrollY() + dyUnconsumed);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (dy > 0) {
            int newY = this.getScrollY() + dy;
            if (newY < this.maxY) {
                consumed[1] = dy;
            }
            this.scrollTo(this.getScrollX(), newY);
        }
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        boolean isDragging;
        boolean bl = isDragging = this.getScrollY() > this.minY && this.getScrollY() < this.maxY;
        if (isDragging && velocityY < -1500.0f && !this.isThreeDrag) {
            this.close();
        }
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return false;
    }

    public int getNestedScrollAxes() {
        return 2;
    }

    public void isThreeDrag(boolean isThreeDrag) {
        this.isThreeDrag = isThreeDrag;
    }

    public void enableDrag(boolean enableDrag) {
        this.enableDrag = enableDrag;
    }

    public void dismissOnTouchOutside(boolean dismissOnTouchOutside) {
        this.dismissOnTouchOutside = dismissOnTouchOutside;
    }

    public void setOnCloseListener(OnCloseListener listener) {
        this.listener = listener;
    }

    public static interface OnCloseListener {
        public void onClose();

        public void onDrag(int var1, float var2, boolean var3);

        public void onOpen();
    }
}

