/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Utils {
    public static <K, V> Map<K, V> zipMap(K[] keys, V[] values) {
        Preconditions.checkArgument((values.length == keys.length ? 1 : 0) != 0, (String)"number of values[%s] different than number of keys[%s]", (Object[])new Object[]{values.length, keys.length});
        return Utils.zipMapPartial(keys, values);
    }

    public static <K, V> Map<K, V> zipMapPartial(K[] keys, V[] values) {
        Preconditions.checkArgument((values.length <= keys.length ? 1 : 0) != 0, (String)"number of values[%s] exceeds number of keys[%s]", (Object[])new Object[]{values.length, keys.length});
        LinkedHashMap<K, V> retVal = new LinkedHashMap<K, V>();
        for (int i = 0; i < values.length; ++i) {
            retVal.put(keys[i], values[i]);
        }
        return retVal;
    }

    public static <K, V> Map<K, V> zipMap(Iterable<K> keys, Iterable<V> values) {
        LinkedHashMap<K, V> retVal = new LinkedHashMap<K, V>();
        Iterator<K> keysIter = keys.iterator();
        Iterator<V> valsIter = values.iterator();
        while (keysIter.hasNext()) {
            K key = keysIter.next();
            Preconditions.checkArgument((boolean)valsIter.hasNext(), (String)"number of values[%s] less than number of keys, broke on key[%s]", (Object[])new Object[]{retVal.size(), key});
            retVal.put(key, valsIter.next());
        }
        Preconditions.checkArgument((!valsIter.hasNext() ? 1 : 0) != 0, (String)"number of values[%s] exceeds number of keys[%s]", (Object[])new Object[]{retVal.size() + Iterators.size(valsIter), retVal.size()});
        return retVal;
    }

    public static <K, V> Map<K, V> zipMapPartial(Iterable<K> keys, Iterable<V> values) {
        LinkedHashMap<K, V> retVal = new LinkedHashMap<K, V>();
        Iterator<K> keysIter = keys.iterator();
        Iterator<V> valsIter = values.iterator();
        while (keysIter.hasNext()) {
            K key = keysIter.next();
            if (!valsIter.hasNext()) break;
            retVal.put(key, valsIter.next());
        }
        return retVal;
    }
}

