/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.date;

import com.mzlion.core.date.DateCalcUtils;
import com.mzlion.core.date.ThreadSafeDateParse;
import com.mzlion.core.lang.StringUtils;
import java.text.ParseException;
import java.util.Date;

public class DateUtils {
    public static final String PATTERN_FULL = "yyyyMMddHHmmss";
    public static final String PATTERN = "yyyyMMdd";

    public static String formatDate() {
        return DateUtils.formatDate(PATTERN_FULL);
    }

    public static String formatDate(String pattern) {
        return DateUtils.formatDate(System.currentTimeMillis(), pattern);
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.formatDate(date, PATTERN_FULL);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null || !StringUtils.hasLength(pattern)) {
            return null;
        }
        return ThreadSafeDateParse.format(date, pattern);
    }

    public static String formatDate(long date, String pattern) {
        if (date <= 0L || !StringUtils.hasLength(pattern)) {
            return null;
        }
        return ThreadSafeDateParse.format(date, pattern);
    }

    public static String formatDate(long date) {
        return DateUtils.formatDate(date, PATTERN_FULL);
    }

    public static Date parseDate(String strDate, String pattern) {
        if (!StringUtils.hasText(strDate) || !StringUtils.hasText(pattern)) {
            return null;
        }
        try {
            return ThreadSafeDateParse.parse(strDate, pattern);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Date parseDate(String strDate) {
        return DateUtils.parseDate(strDate, PATTERN_FULL);
    }

    public static Date parseDateByLongStr(String longStrDate) {
        if (StringUtils.hasText(longStrDate)) {
            return new Date(Long.parseLong(longStrDate));
        }
        return null;
    }

    public static String swapDateStr(String srcDate, String sourceFormat, String destFotrmat) {
        Date date = DateUtils.parseDate(srcDate, sourceFormat);
        return DateUtils.formatDate(date, destFotrmat);
    }

    public static String formatNextDate(int days, String pattern) {
        return DateUtils.formatNextDate(new Date(), days, pattern);
    }

    public static String formatNextDate(Date date, int days, String pattern) {
        Date nextDate = DateCalcUtils.addDate(date, days);
        return DateUtils.formatDate(nextDate, pattern);
    }

    public static String formatNextMonths(int months, String pattern) {
        return DateUtils.formatNextMonths(new Date(), months, pattern);
    }

    public static String formatNextMonths(long specialTime, int months, String pattern) {
        return DateUtils.formatNextMonths(new Date(specialTime), months, pattern);
    }

    public static String formatNextMonths(Date specialDate, int months, String pattern) {
        Date targetDate = DateCalcUtils.addMonth(specialDate, months);
        return DateUtils.formatDate(targetDate, pattern);
    }

    public static String formatBeginDayInMonth(String pattern) {
        return DateUtils.formatBeginDayInMonth(new Date(), pattern);
    }

    public static String formatBeginDayInMonth(Date specialDate, String pattern) {
        if (specialDate == null) {
            return null;
        }
        specialDate = DateCalcUtils.getBeginDayInMonth(specialDate);
        return DateUtils.formatDate(specialDate, pattern);
    }
}

